/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.dlpar;

import com.ibm.hsc.auiml.databeans.dlpar.PIHscDlparBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.diagnostics.IDebug;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class PIHscDlparProcessorBean
extends PIHscDlparBean
implements TaskNotifyCompleteListener {
    public final String ERR_NO_CPU_MOVE_DEST = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NO_CPU_MOVE_DEST", "No destination LPAR is selected for processor move operation.");
    public final String ERR_NO_CPU_SEL = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NO_CPU_SEL", "The number of processor selected for DLPAR operation is equal to less than 0.");
    private final String ERR_UNCAPPED_RANGE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_UNCAPPED_RANGE", "should be greater than 0 and lesser than 255");
    private String msg = null;
    private int curProcs = 0;
    private long curProcUnits = 0L;
    private int curVirProcs = 0;
    private long curIntPerf = 0L;
    private int sharingMode = 0;
    private int curUncappedWeight = 128;
    private String m_sMaxProcessors;
    private String m_sCurrentProcessors;
    private double m_dProcAmountToAdd;
    private double m_dProdAfterAdd;
    private String m_sMaxIntPerf;
    private String m_sCurrentIntPerf;
    private double m_dAmtToAddIntPerf;
    private double m_dAfterAddIntPerf;
    private String m_sMaxProcUnits;
    private String m_sCurrentProcUnits;
    private double m_dAmtToAddProcUnits;
    private String m_sAfterAddProcUnits;
    private String m_sMaxVirProc;
    private String m_sCurrentVirProc;
    private double m_dAmtToAddVirProc;
    private double m_dAfterAddVirProc;
    private double m_dUncappedWeight;
    private String m_sFreeProcs;
    private String m_sFreeProcUnits;
    private double m_dAmtToRemoveProcs;
    private double m_dAfterRemoveProcs;
    private String m_sMinProcUnits;
    private double m_dAmtToRemoveProcUnits;
    private String m_sAfterRemoveProcUnits;
    private String m_sMinVirProc;
    private double m_dAmtToRemoveVirProc;
    private double m_dAfterRemoveVirProc;
    private String m_sMinIntPerf;
    private double m_dAmtToRemoveIntPerf;
    private String m_sSourceMinProcs;
    private String m_sSourceMaxProcs;
    private String m_sSourceCurrentProcs;
    private double m_dSourceAmtToMoveProcs;
    private double m_dSourceAfterMoveProcs;
    private String m_sSourceMinIntPerf;
    private String m_sSourceMaxIntPerf;
    private double m_dSourceCurrentIntPerf;
    private String m_sMoveTo;
    private ValueDescriptor[] m_cdMoveTo;
    private ValueDescriptor[] m_tmp;
    private String m_sDestMinProcUnits;
    private String m_sDestMaxProcUnits;
    private String m_sDestCurrentProcUnits;
    private String m_sDestAfterMoveProcUnits;
    private String m_sDestMinIntPerf;
    private String m_sDestMaxIntPerf;
    private double m_dDestCurrentIntPerf;
    private String m_sDestMinProcs;
    private String m_sDestMaxProcs;
    private String m_sDestCurrentProcs;
    private String m_sDestAfterMoveProcs;
    private String m_sDestMinVirProc;
    private String m_sDestMaxVirProc;
    private double m_dDestCurrentVirProc;
    private String m_sSourceMinProcUnits;
    private String m_sSourceMaxProcUnits;
    private String m_sSourceCurrentProcUnits;
    private double m_dSourceAmtToMoveProcUnits;
    private double m_dSourceAfterMoveProcUnits;
    private String m_sSourceMinVirProc;
    private String m_sSourceMaxVirProc;
    private double m_dSourceCurrentVirProc;
    private double m_dSourceUncappedWeight;
    private double m_dDestUncappedWeight;
    private String m_sMaxProcs;
    private String m_sCurrentProcs;
    private double m_dAmtToAddProcs;
    private double m_dAfterAddProcs;
    private String m_sMinProcs;
    private double m_dAfterRemoveIntPerf;
    private double m_dAmtToMoveProcUnits;
    private String m_sAfterMoveProcUnits;
    private double m_dDetail;
    private double m_dTimeout;
    private String m_sDestCuurentProcUnits;
    private double m_dSourceCurrentUncappedWeight;
    private double m_dSourceAfterMoveIntPerf;
    private double m_dDestAfterMoveIntPerf;
    private double m_dSourceAfterMoveVirProc;
    private String m_sDestProcs;
    private String m_sDestAfterMoveVirProc;
    private boolean m_bUncapped = false;
    private String m_sDestOptimalIntRange = "";
    private double m_dSourceAmtToMoveVirProc;
    private String m_sSourceOptimalIntRange = "";
    private boolean m_bDestUncapped;
    private boolean m_bSourceUncapped;
    private int phypConfigProcUnits = 0;
    private boolean allowToShowCPW = true;
    private boolean closePanel = true;
    protected ValueDescriptor[] m_cdDetail;
    protected ValueDescriptor[] m_cdTimeout;
    protected String m_sDetailLevel;
    protected ValueDescriptor[] m_cdDetailLevel;

    public PIHscDlparProcessorBean(String string, String string2) {
        super(string, string2);
    }

    private void refreshAndReturn(String string) {
        this.mUsrTaskMgr.refreshElement(string);
    }

    private int toInt(String string) {
        return Integer.parseInt(string);
    }

    private double setFormat(double d) {
        try {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            String string = numberFormat.format(d).toString();
            this.debug("formatted string : " + string);
            double d2 = Double.parseDouble(string);
            this.debug("converted double  = " + d2);
            return d2;
        }
        catch (Exception exception) {
            this.debug("setFormat failed for : " + d);
            return 0.0;
        }
    }

    private double toDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        try {
            double d = Double.parseDouble(string);
            this.debug("toDouble(String " + string + ") is " + d);
            return d;
        }
        catch (Exception exception) {
            this.debug("parseDouble failed for value " + string);
            return 0.0;
        }
    }

    private void setChangedProcValues(String string) {
    }

    private void setChangedProcUnitValues(String string) {
    }

    private void setChangedVirProcValues(String string) {
    }

    private void setChangedIntPerfValues(String string) {
    }

    private void checkDestIntPerf(String string) {
        double d = this.getDestCurrentIntPerf();
        this.mUsrTaskMgr.storeAllElements();
        double d2 = this.toDouble(this.getDestMinIntPerf());
        double d3 = this.toDouble(this.getDestMaxIntPerf());
        boolean bl = false;
        if (this.getDestCurrentIntPerf() > d3) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_INT_PER_LT_MAX_INT_PER", "Current Interactive Performance {0} should be less than Maximum Interactive Performance {1} \n", new String[]{"" + this.getDestCurrentIntPerf(), "" + d3});
            bl = true;
        }
        if (this.getDestCurrentIntPerf() < d2) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_INT_PER_GT_MIN_INT_PER", "Current Interactive Performance {0} should be greater than Minimum Interactive Performance {1} \n", new String[]{"" + this.getDestCurrentIntPerf(), "" + d2});
            bl = true;
        }
        if (bl) {
            this.showInfo(this.msg, null, null);
            this.setDestCurrentIntPerf(d);
            this.refreshAndReturn(string);
        }
    }

    private void checkDestVirProc(String string) {
        int n = (int)this.getDestCurrentVirProc();
        this.mUsrTaskMgr.storeAllElements();
        int n2 = this.toInt(this.getDestMinVirProc());
        int n3 = this.toInt(this.getDestMaxVirProc());
        boolean bl = false;
        if (this.getDestCurrentVirProc() > (double)n3) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_VIR_PROC_LT_MAX_VIR_PROC", "Current Virtual Processor {0} should be less than Maximum Virtual Processor {1} \n", new String[]{"" + this.getDestCurrentVirProc(), "" + n3});
            bl = true;
        }
        if (this.getDestCurrentVirProc() < (double)n2) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_VIR_PROC_GT_MIN_VIR_PROC", "Current Virtual Processor {0} should be greater than Minimum Virtual Processor {1} \n", new String[]{"" + this.getDestCurrentVirProc(), "" + n2});
            bl = true;
        }
        if (bl) {
            this.showInfo(this.msg, null, null);
            this.setDestCurrentVirProc(n);
            this.refreshAndReturn(string);
        }
    }

    private void hideMoveToElements() {
        for (int i = 0; i < this.mMoveToElements.length; ++i) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mMoveToElements[i], false);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mMoveToElements[i]);
        }
    }

    private void destIsRPADedicated() {
        int n;
        this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel, true);
        for (n = 0; n < this.mDestIsRPADedicatedDisable.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsRPADedicatedDisable[n], false);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsRPADedicatedDisable[n]);
        }
        for (n = 0; n < this.mDestIsRPADedicated.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsRPADedicated[n], true);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsRPADedicated[n]);
        }
    }

    private void destIsRPAShared() {
        int n;
        this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel, true);
        for (n = 0; n < this.mDestIsRPASharedDisable.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsRPASharedDisable[n], false);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsRPASharedDisable[n]);
        }
        for (n = 0; n < this.mDestIsRPAShared.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsRPAShared[n], true);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsRPAShared[n]);
        }
    }

    private void destIsOS400Dedicated() {
        int n;
        this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel, true);
        for (n = 0; n < this.mDestIsOS400DedicatedDisable.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsOS400DedicatedDisable[n], false);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsOS400DedicatedDisable[n]);
        }
        for (n = 0; n < this.mDestIsOS400Dedicated.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsOS400Dedicated[n], true);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsOS400Dedicated[n]);
        }
    }

    private void destIsOS400Shared() {
        int n;
        this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel, true);
        for (n = 0; n < this.mDestIsOS400SharedDisable.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsOS400SharedDisable[n], false);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsOS400SharedDisable[n]);
        }
        for (n = 0; n < this.mDestIsOS400Shared.length; ++n) {
            this.mUsrTaskMgr.setShown(this.mCurrentMoveToPanel + "." + this.mDestIsOS400Shared[n], true);
            this.mUsrTaskMgr.refreshElement(this.mCurrentMoveToPanel + "." + this.mDestIsOS400Shared[n]);
        }
    }

    public void taskCompleted(String string) {
        String string2;
        if (this.RPA_PARTITION.equals(this.partType) && 255 == this.procMode) {
            this.setChangedProcValues(string);
        } else if (this.RPA_PARTITION.equals(this.partType) && 255 != this.procMode) {
            this.setChangedProcUnitValues(string);
            this.setChangedVirProcValues(string);
        } else if (this.OS400_PARTITION.equals(this.partType) && 255 == this.procMode) {
            this.setChangedProcValues(string);
            this.setChangedIntPerfValues(string);
        } else if (this.OS400_PARTITION.equals(this.partType) && 255 != this.procMode) {
            this.setChangedProcValues(string);
            this.setChangedVirProcValues(string);
            this.setChangedIntPerfValues(string);
        }
        if (this.RPA_PARTITION.equals(this.destPartType) && 255 != this.destProcMode) {
            if (string.equals("DestCurrentVirProc")) {
                this.checkDestVirProc("DestCurrentVirProc");
            }
        } else if (this.OS400_PARTITION.equals(this.destPartType) && 255 == this.destProcMode) {
            if (string.equals("DestCurrentIntPerf")) {
                this.checkDestIntPerf("DestCurrentIntPerf");
            }
        } else if (this.OS400_PARTITION.equals(this.destPartType) && 255 != this.destProcMode) {
            if (string.equals("DestCurrentIntPerf")) {
                this.checkDestIntPerf("DestCurrentIntPerf");
            }
            if (string.equals("DestCurrentVirProc")) {
                this.checkDestVirProc("DestCurrentVirProc");
            }
        }
        if ((string2 = this.getMoveDest()) == null) {
            return;
        }
        this.mUsrTaskMgr.refreshAllElements();
    }

    public void taskCompleted(TaskNotifyCompleteEvent taskNotifyCompleteEvent) {
        String string;
        String string2 = taskNotifyCompleteEvent.getElementName();
        if (this.RPA_PARTITION.equals(this.partType) && 255 == this.procMode) {
            this.setChangedProcValues(string2);
        } else if (this.RPA_PARTITION.equals(this.partType) && 255 != this.procMode) {
            this.setChangedProcUnitValues(string2);
            this.setChangedVirProcValues(string2);
        } else if (this.OS400_PARTITION.equals(this.partType) && 255 == this.procMode) {
            this.setChangedProcValues(string2);
            this.setChangedIntPerfValues(string2);
        } else if (this.OS400_PARTITION.equals(this.partType) && 255 != this.procMode) {
            this.setChangedProcValues(string2);
            this.setChangedVirProcValues(string2);
            this.setChangedIntPerfValues(string2);
        }
        if (this.RPA_PARTITION.equals(this.destPartType) && 255 != this.destProcMode) {
            if (string2.equals("DestCurrentVirProc")) {
                this.checkDestVirProc("DestCurrentVirProc");
            }
        } else if (this.OS400_PARTITION.equals(this.destPartType) && 255 == this.destProcMode) {
            if (string2.equals("DestCurrentIntPerf")) {
                this.checkDestIntPerf("DestCurrentIntPerf");
            }
        } else if (this.OS400_PARTITION.equals(this.destPartType) && 255 != this.destProcMode) {
            if (string2.equals("DestCurrentIntPerf")) {
                this.checkDestIntPerf("DestCurrentIntPerf");
            }
            if (string2.equals("DestCurrentVirProc")) {
                this.checkDestVirProc("DestCurrentVirProc");
            }
        }
        if ((string = this.getMoveDest()) == null) {
            return;
        }
        this.mUsrTaskMgr.refreshAllElements();
    }

    public String getMoveDest() {
        return null;
    }

    public void setMaxProcessors(String string) throws IllegalUserDataException {
        this.m_sMaxProcessors = string;
    }

    public String getMaxProcessors() {
        return this.m_sMaxProcessors;
    }

    public void setCurrentProcessors(String string) throws IllegalUserDataException {
        this.m_sCurrentProcessors = string;
    }

    public String getCurrentProcessors() {
        return this.m_sCurrentProcessors;
    }

    public void setProcAmountToAdd(double d) throws IllegalUserDataException {
        this.m_dProcAmountToAdd = d;
    }

    public double getProcAmountToAdd() {
        return this.m_dProcAmountToAdd;
    }

    public void setProdAfterAdd(double d) throws IllegalUserDataException {
        this.m_dProdAfterAdd = d;
    }

    public double getProdAfterAdd() {
        return this.m_dProdAfterAdd;
    }

    public void setMaxIntPerf(String string) throws IllegalUserDataException {
        this.m_sMaxIntPerf = string;
    }

    public String getMaxIntPerf() {
        return this.m_sMaxIntPerf;
    }

    public void setCurrentIntPerf(String string) throws IllegalUserDataException {
        this.m_sCurrentIntPerf = string;
    }

    public String getCurrentIntPerf() {
        return this.m_sCurrentIntPerf;
    }

    public void setAmtToAddIntPerf(double d) throws IllegalUserDataException {
        this.m_dAmtToAddIntPerf = d;
    }

    public double getAmtToAddIntPerf() {
        return this.m_dAmtToAddIntPerf;
    }

    public void setAfterAddIntPerf(double d) throws IllegalUserDataException {
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dAfterAddIntPerf = 0.0;
        } else if (d > this.setFormat(this.toDouble(this.getMaxIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMaxIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterAddIntPerf = 0.0;
        } else if (d < this.setFormat(this.toDouble(this.getMinIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MIN_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is smaller than the minimum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMinIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterAddIntPerf = 0.0;
        } else {
            this.m_dAfterAddIntPerf = d;
        }
        this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddIntPerf");
    }

    public double getAfterAddIntPerf() {
        return this.m_dAfterAddIntPerf;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void setMaxProcUnits(String string) throws IllegalUserDataException {
        this.m_sMaxProcUnits = string;
    }

    public String getMaxProcUnits() {
        return this.m_sMaxProcUnits;
    }

    public void setCurrentProcUnits(String string) throws IllegalUserDataException {
        this.debug("setCurrentProcUnits() :  " + string);
        this.m_sCurrentProcUnits = string;
    }

    public String getCurrentProcUnits() {
        this.debug("getCurrentProcUnits() :  " + this.m_sCurrentProcUnits);
        return this.m_sCurrentProcUnits;
    }

    public void setAmtToAddProcUnits(double d) throws IllegalUserDataException {
        this.closePanel = true;
        if (!this.mfgDefConfig) {
            this.debug("setAmtToAddProcUnits() : " + d);
            if (d < 0.0) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
                this.showInfo(this.msg, null, null);
                this.m_dAmtToAddProcUnits = 0.0;
                this.m_sAfterAddProcUnits = this.formatDoubleToString(this.toDouble(this.getCurrentProcUnits()));
                this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddProcUnits");
            } else if (d > this.setFormat(this.toDouble(this.getMaxProcUnits()) - this.toDouble(this.getCurrentProcUnits()))) {
                this.closePanel = false;
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxProcUnits()) - this.toDouble(this.getCurrentProcUnits()))});
                this.showInfo(this.msg, null, null);
                this.m_dAmtToAddProcUnits = 0.0;
                this.m_sAfterAddProcUnits = this.formatDoubleToString(this.toDouble(this.getCurrentProcUnits()));
                this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddProcUnits");
            } else {
                this.m_dAmtToAddProcUnits = d;
                this.m_sAfterAddProcUnits = this.formatDoubleToString(this.m_dAmtToAddProcUnits + this.toDouble(this.getCurrentProcUnits()));
                this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddProcUnits");
            }
        } else {
            this.m_dAmtToAddProcUnits = d;
        }
        this.refreshAndReturn(this.mCurrentAddPanel + ".AmtToAddProcUnits");
    }

    public double getAmtToAddProcUnits() {
        return this.m_dAmtToAddProcUnits;
    }

    public void setAfterAddProcUnits(double d) throws IllegalUserDataException {
        this.m_sAfterAddProcUnits = Double.toString(this.setFormat(d));
    }

    public String getAfterAddProcUnits() {
        return this.m_sAfterAddProcUnits;
    }

    public void setMaxVirProc(String string) throws IllegalUserDataException {
        this.m_sMaxVirProc = string;
    }

    public String getMaxVirProc() {
        return this.m_sMaxVirProc;
    }

    public void setCurrentVirProc(String string) throws IllegalUserDataException {
        this.m_sCurrentVirProc = string;
    }

    public String getCurrentVirProc() {
        return this.m_sCurrentVirProc;
    }

    public void setAmtToAddVirProc(double d) throws IllegalUserDataException {
        if (d > this.setFormat(this.toDouble(this.getMaxVirProc()) - this.toDouble(this.getCurrentVirProc()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxVirProc()) - this.toDouble(this.getCurrentVirProc()))});
            this.showInfo(this.msg, null, null);
            this.m_dAmtToAddVirProc = 0.0;
        } else {
            this.m_dAmtToAddVirProc = d;
            this.m_dAfterAddVirProc = this.setFormat(this.m_dAmtToAddVirProc + this.toDouble(this.getCurrentVirProc()));
        }
    }

    public double getAmtToAddVirProc() {
        return this.m_dAmtToAddVirProc;
    }

    public void setAfterAddVirProc(double d) throws IllegalUserDataException {
        this.debug("setAfterAddVirProc() : " + d);
        if (d > this.toDouble(this.getMaxVirProc())) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxVirProc()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterAddVirProc = 0.0;
        } else {
            this.debug("value d = " + d);
            this.m_dAfterAddVirProc = d;
        }
        this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddVirProc");
    }

    public double getAfterAddVirProc() {
        return this.m_dAfterAddVirProc;
    }

    public void setUncappedWeight(double d) throws IllegalUserDataException {
        this.m_dUncappedWeight = d;
    }

    public double getUncappedWeight() {
        return this.m_dUncappedWeight;
    }

    public void setUncapped(boolean bl) throws IllegalUserDataException {
        this.m_bUncapped = bl;
        this.debug("setUncapped()=" + this.m_bUncapped);
    }

    public boolean getUncapped() {
        return this.m_bUncapped;
    }

    public boolean isUncapped() {
        this.debug("isUncapped()=" + this.m_bUncapped);
        return this.m_bUncapped;
    }

    public void setFreeProcs(String string) throws IllegalUserDataException {
        this.m_sFreeProcs = string;
    }

    public String getFreeProcs() {
        return this.m_sFreeProcs;
    }

    public void setFreeProcUnits(String string) throws IllegalUserDataException {
        this.m_sFreeProcUnits = string;
    }

    public String getFreeProcUnits() {
        return this.m_sFreeProcUnits;
    }

    public boolean getPanelState() {
        return this.m_bPanelState;
    }

    public void setPanelState(boolean bl) {
        this.m_bPanelState = bl;
    }

    public void setAmtToRemoveProcs(double d) throws IllegalUserDataException {
        if (!this.mfgDefConfig) {
            if (d > this.setFormat(this.toDouble(this.getCurrentProcs()) - this.toDouble(this.getMinProcs()))) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxProcs()) - this.toDouble(this.getCurrentProcs()))});
                this.showInfo(this.msg, null, null);
                this.m_dAmtToRemoveProcs = 0.0;
                this.m_dAfterRemoveProcs = this.setFormat(this.toDouble(this.getCurrentProcs()));
            } else {
                this.m_dAmtToRemoveProcs = d;
                this.m_dAfterRemoveProcs = this.setFormat(this.toDouble(this.getCurrentProcs()) - this.m_dAmtToRemoveProcs);
                this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveProcs");
            }
        } else {
            this.m_dAmtToRemoveProcs = d;
        }
    }

    public double getAmtToRemoveProcs() {
        return this.m_dAmtToRemoveProcs;
    }

    public void setAfterRemoveProcs(double d) throws IllegalUserDataException {
        this.m_dAfterRemoveProcs = d;
    }

    public double getAfterRemoveProcs() {
        return this.m_dAfterRemoveProcs;
    }

    public void setMinProcUnits(String string) throws IllegalUserDataException {
        this.m_sMinProcUnits = string;
    }

    public String getMinProcUnits() {
        return this.m_sMinProcUnits;
    }

    public void setAmtToRemoveProcUnits(double d) throws IllegalUserDataException {
        this.closePanel = true;
        if (!this.mfgDefConfig) {
            this.debug("setAmtToRemoveProcUnits()");
            if (d < 0.0) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
                this.showInfo(this.msg, null, null);
                this.m_dAmtToRemoveProcUnits = 0.0;
                this.m_sAfterRemoveProcUnits = this.formatDoubleToString(this.toDouble(this.getCurrentProcUnits()));
                this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveProcUnits");
            } else if (d > this.setFormat(this.toDouble(this.getCurrentProcUnits()) - this.toDouble(this.getMinProcUnits()))) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getCurrentProcUnits()) - this.toDouble(this.getMinProcUnits()))});
                this.showInfo(this.msg, null, null);
                this.m_dAmtToRemoveProcUnits = 0.0;
                this.closePanel = false;
                this.m_sAfterRemoveProcUnits = this.formatDoubleToString(this.toDouble(this.getCurrentProcUnits()));
                this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveProcUnits");
            } else {
                this.m_dAmtToRemoveProcUnits = d;
                this.m_sAfterRemoveProcUnits = this.formatDoubleToString(this.toDouble(this.getCurrentProcUnits()) - this.m_dAmtToRemoveProcUnits);
                this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveProcUnits");
            }
        } else {
            this.m_dAmtToRemoveProcUnits = d;
        }
        this.refreshAndReturn(this.mCurrentRemovePanel + ".AmtToRemoveProcUnits");
    }

    public double getAmtToRemoveProcUnits() {
        return this.m_dAmtToRemoveProcUnits;
    }

    private String formatDoubleToString(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(1);
        String string = numberFormat.format(d).toString();
        this.debug("formatDoubleToString().str =  " + string);
        return string;
    }

    public void setAfterRemoveProcUnits(String string) throws IllegalUserDataException {
        this.m_sAfterRemoveProcUnits = string;
    }

    public String getAfterRemoveProcUnits() {
        return this.m_sAfterRemoveProcUnits;
    }

    public void setMinVirProc(String string) throws IllegalUserDataException {
        this.m_sMinVirProc = string;
    }

    public String getMinVirProc() {
        return this.m_sMinVirProc;
    }

    public void setAmtToRemoveVirProc(double d) throws IllegalUserDataException {
        this.m_dAmtToRemoveVirProc = d;
    }

    public double getAmtToRemoveVirProc() {
        return this.m_dAmtToRemoveVirProc;
    }

    public void setAfterRemoveVirProc(double d) throws IllegalUserDataException {
        this.debug("setAfterRemoveVirProc");
        if (d > this.setFormat(this.toDouble(this.getCurrentVirProc()) - this.toDouble(this.getMinVirProc()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getCurrentVirProc()) - this.toDouble(this.getMinVirProc()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterRemoveVirProc = 0.0;
        } else {
            this.m_dAfterRemoveVirProc = d;
        }
    }

    public double getAfterRemoveVirProc() {
        return this.m_dAfterRemoveVirProc;
    }

    public void setMinIntPerf(String string) throws IllegalUserDataException {
        this.m_sMinIntPerf = string;
    }

    public String getMinIntPerf() {
        return this.m_sMinIntPerf;
    }

    public void setAmtToRemoveIntPerf(double d) throws IllegalUserDataException {
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dAmtToRemoveIntPerf = 0.0;
            this.m_dAfterRemoveIntPerf = this.setFormat(this.toDouble(this.getCurrentIntPerf()));
            this.refreshAndReturn(this.mCurrentRemovePanel + ".AmtToRemoveIntPerf");
        } else if (d > this.setFormat(this.toDouble(this.getMaxIntPerf()) - this.toDouble(this.getCurrentIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxIntPerf()) - this.toDouble(this.getCurrentIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dAmtToRemoveIntPerf = 0.0;
            this.m_dAfterRemoveIntPerf = this.setFormat(this.toDouble(this.getCurrentIntPerf()));
        } else {
            this.m_dAmtToRemoveIntPerf = d;
            this.m_dAfterRemoveIntPerf = this.setFormat(this.m_dAmtToRemoveIntPerf + this.toDouble(this.getCurrentIntPerf()));
        }
        this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveIntPerf");
    }

    public double getAmtToRemoveIntPerf() {
        return this.m_dAmtToRemoveIntPerf;
    }

    public void setSourceMinProcs(String string) throws IllegalUserDataException {
        this.m_sSourceMinProcs = string;
    }

    public String getSourceMinProcs() {
        return this.m_sSourceMinProcs;
    }

    public void setSourceMaxProcs(String string) throws IllegalUserDataException {
        this.m_sSourceMaxProcs = string;
    }

    public String getSourceMaxProcs() {
        return this.m_sSourceMaxProcs;
    }

    public void setSourceCurrentProcs(String string) throws IllegalUserDataException {
        this.m_sSourceCurrentProcs = string;
    }

    public String getSourceCurrentProcs() {
        return this.m_sSourceCurrentProcs;
    }

    public void setSourceAmtToMoveProcs(double d) throws IllegalUserDataException {
        this.debug("setSourceAmtToMoveProcs() : " + d);
        if (d > this.setFormat(this.toDouble(this.getSourceCurrentProcs()) - this.toDouble(this.getSourceMinProcs()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceCurrentProcs()) - this.toDouble(this.getSourceMinProcs()))});
            this.showInfo(this.msg, null, null);
            this.m_dSourceAmtToMoveProcs = 0.0;
            this.m_dSourceAfterMoveProcs = this.setFormat(this.toDouble(this.getSourceCurrentProcs()));
        } else {
            this.m_dSourceAmtToMoveProcs = d;
            String string = this.getMoveTo();
            if (255 == this.destProcMode) {
                this.debug("checking multilples of 100");
                if (Math.IEEEremainder(d, 1.0) != 0.0) {
                    this.debug("should be multiples of 100");
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_CPU_PROC_UNIT_100", "Processing units {0}  should be multiples of 1", new String[]{"" + d});
                    this.showInfo(this.msg, null, null);
                    this.m_dSourceAmtToMoveProcs = 0.0;
                    this.m_dSourceAfterMoveProcs = 0.0;
                } else if (this.setFormat(this.toDouble(this.getDestMaxProcs()) - this.toDouble(this.getDestCurrentProcs())) >= d) {
                    this.m_dSourceAfterMoveProcs = this.setFormat(this.toDouble(this.getSourceCurrentProcs()) - this.m_dSourceAmtToMoveProcs);
                    this.debug("m_dSourceAfterMoveProcs = " + this.m_dSourceAfterMoveProcs);
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcs");
                    if (string != null && string.trim().length() > 0) {
                        this.m_sDestAfterMoveProcs = Double.toString(this.setFormat(this.toDouble(this.getDestCurrentProcs()) + d));
                        this.debug("m_sDestAfterMoveProcs = " + this.m_sDestAfterMoveProcs);
                        this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveProcs");
                    }
                } else if (string != null && string.trim().length() > 0) {
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_MOVE", "You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxProcs()) - this.toDouble(this.getDestCurrentProcs()))});
                    this.showInfo(this.msg, null, null);
                    this.m_dSourceAmtToMoveProcs = 0.0;
                    this.m_dSourceAfterMoveProcs = 0.0;
                }
            } else if (this.setFormat(this.toDouble(this.getDestMaxProcUnits()) - this.toDouble(this.getDestCurrentProcUnits())) >= d) {
                this.m_dSourceAfterMoveProcs = this.setFormat(this.toDouble(this.getSourceCurrentProcs()) - d);
                this.debug("m_dSourceAfterMoveProcs = " + this.m_dSourceAfterMoveProcs);
                this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcs");
                if (string != null && string.trim().length() > 0) {
                    this.m_sDestAfterMoveProcUnits = Double.toString(this.setFormat(this.toDouble(this.getDestCurrentProcUnits()) + d));
                    this.debug("m_sDestAfterMoveProcUnits = " + this.m_sDestAfterMoveProcUnits);
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveProcUnits");
                }
            } else if (string != null && string.trim().length() > 0) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_MOVE", "You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxProcUnits()) - this.toDouble(this.getDestCurrentProcUnits()))});
                this.showInfo(this.msg, null, null);
                this.m_dSourceAmtToMoveProcs = 0.0;
                this.m_dSourceAfterMoveProcs = 0.0;
            }
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAmtToMoveProcs");
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcs");
    }

    public void setPHYPIntRangeValues(String string, String string2) throws Exception {
        UnsignedInt16[] unsignedInt16Array = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string3 = "";
        String string4 = "";
        if (string.equals("sourceIntRangeButton")) {
            if (255 == this.procMode) {
                if (this.mAction.equals("add") && string2.equals("action")) {
                    d = this.getAfterAddProcs();
                } else if (this.mAction.equals("move") && string2.equals("action")) {
                    d = this.getSourceAfterMoveProcs();
                } else if (this.mAction.equals("remove") && string2.equals("action")) {
                    d = this.getAfterRemoveProcs();
                }
                if ((this.mAction.equals("add") || this.mAction.equals("remove")) && string2.equals("bringup")) {
                    d = this.toDouble(this.getCurrentProcs());
                } else if (this.mAction.equals("move") && string2.equals("bringup")) {
                    d = this.toDouble(this.getSourceCurrentProcs());
                }
                try {
                    unsignedInt16Array = this.getOptimalInteractiveRange(this.mLparKey, new UnsignedInt32((long)((int)d * 100)));
                }
                catch (Exception exception) {
                    if (IDebug.enabled) {
                        exception.printStackTrace();
                    }
                    this.debug("Exception while getting getOptimalInteractive");
                }
                if (unsignedInt16Array != null && unsignedInt16Array[0] != null && unsignedInt16Array[1] != null) {
                    this.debug("min and max value : " + unsignedInt16Array[0].intValue() + " and " + unsignedInt16Array[1].intValue());
                    d2 = unsignedInt16Array[0].intValue() / 100;
                    d3 = unsignedInt16Array[1].intValue() / 100;
                    string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                    string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                    string3 = string3 + d2 + " - " + d3;
                    if (this.allowToShowCPW) {
                        this.setSourceOptimalIntRange(string3);
                    } else {
                        this.setSourceOptimalIntRange("");
                    }
                }
            } else {
                if (this.mAction.equals("add") && string2.equals("action")) {
                    d = this.toDouble(this.getAfterAddProcUnits());
                } else if (this.mAction.equals("move") && string2.equals("action")) {
                    d = this.getSourceAfterMoveProcUnits();
                } else if (this.mAction.equals("remove") && string2.equals("action")) {
                    d = this.toDouble(this.getAfterRemoveProcUnits());
                }
                if ((this.mAction.equals("add") || this.mAction.equals("remove")) && string2.equals("bringup")) {
                    d = this.toDouble(this.getCurrentProcUnits());
                } else if (this.mAction.equals("move") && string2.equals("bringup")) {
                    d = this.toDouble(this.getSourceCurrentProcUnits());
                }
                try {
                    unsignedInt16Array = this.getOptimalInteractiveRange(this.mLparKey, new UnsignedInt32((long)((int)d * 100)));
                }
                catch (Exception exception) {
                    if (IDebug.enabled) {
                        exception.printStackTrace();
                    }
                    this.debug("Exception while getting getOptimalInteractive");
                }
                if (unsignedInt16Array != null && unsignedInt16Array[0] != null && unsignedInt16Array[1] != null) {
                    this.debug("min and max value : " + unsignedInt16Array[0].intValue() + " and " + unsignedInt16Array[1].intValue());
                    d2 = unsignedInt16Array[0].intValue() / 100;
                    d3 = unsignedInt16Array[1].intValue() / 100;
                    string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                    string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                    string3 = string3 + d2 + " - " + d3;
                    if (this.allowToShowCPW) {
                        this.setSourceOptimalIntRange(string3);
                    } else {
                        this.setSourceOptimalIntRange("");
                    }
                }
            }
            this.debug("refresing the SourceOptimalIntRange");
            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceOptimalIntRange");
        } else if (string.equals("destIntRangeButton")) {
            if (255 == this.destProcMode) {
                if (string2.equals("action")) {
                    string4 = this.getDestAfterMoveProcs();
                    if (string4 != null && string4.trim().length() > 0) {
                        d = this.toDouble(this.getDestAfterMoveProcs());
                    }
                } else {
                    string4 = this.getDestCurrentProcs();
                    if (string4 != null && string4.trim().length() > 0) {
                        d = this.toDouble(this.getDestCurrentProcs());
                    }
                }
                this.debug("proc value in setPHYP : " + d);
                this.debug("destLparKey : " + this.destLparKey);
                if (this.destLparKey == null || this.destLparKey.trim().length() == 0) {
                    string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                    string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                    string3 = string3 + " 0  - 100";
                    if (this.allowToShowCPW) {
                        this.setDestOptimalIntRange(string3);
                    } else {
                        this.setDestOptimalIntRange("");
                    }
                } else {
                    block62: {
                        try {
                            unsignedInt16Array = this.getOptimalInteractiveRange(this.destLparKey, new UnsignedInt32((long)((int)d * 100)));
                        }
                        catch (Exception exception) {
                            this.debug(exception.toString());
                            if (!IDebug.enabled) break block62;
                            exception.printStackTrace();
                        }
                    }
                    if (unsignedInt16Array != null && unsignedInt16Array[0] != null && unsignedInt16Array[1] != null) {
                        this.debug("min and max value : " + unsignedInt16Array[0].intValue() + " and " + unsignedInt16Array[1].intValue());
                        d2 = unsignedInt16Array[0].intValue() / 100;
                        d3 = unsignedInt16Array[1].intValue() / 100;
                        string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                        string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                        string3 = string3 + d2 + " - " + d3;
                        if (this.allowToShowCPW) {
                            this.setDestOptimalIntRange(string3);
                        } else {
                            this.setDestOptimalIntRange("");
                        }
                    }
                }
            } else {
                if (string2.equals("action")) {
                    string4 = this.getDestAfterMoveProcUnits();
                    if (string4 != null && string4.trim().length() > 0) {
                        d = this.toDouble(this.getDestAfterMoveProcUnits());
                    }
                } else {
                    string4 = this.getDestCurrentProcUnits();
                    if (string4 != null && string4.trim().length() > 0) {
                        d = this.toDouble(this.getDestCurrentProcUnits());
                    }
                }
                if (this.destLparKey == null || this.destLparKey.trim().length() == 0) {
                    string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                    string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                    string3 = string3 + " 0  - 100";
                    if (this.allowToShowCPW) {
                        this.setDestOptimalIntRange(string3);
                    } else {
                        this.setDestOptimalIntRange("");
                    }
                } else {
                    block63: {
                        try {
                            unsignedInt16Array = this.getOptimalInteractiveRange(this.destLparKey, new UnsignedInt32((long)((int)d * 100)));
                        }
                        catch (Exception exception) {
                            this.debug(exception.toString());
                            if (!IDebug.enabled) break block63;
                            exception.printStackTrace();
                        }
                    }
                    if (unsignedInt16Array != null && unsignedInt16Array[0] != null && unsignedInt16Array[1] != null) {
                        this.debug("min and max value : " + unsignedInt16Array[0].intValue() + " and " + unsignedInt16Array[1].intValue());
                        d2 = unsignedInt16Array[0].intValue() / 100;
                        d3 = unsignedInt16Array[1].intValue() / 100;
                        string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE1", "Optimal Interactive Range for ");
                        string3 = string3 + d + HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OPT_INT_RANGE2", " processing unit is ");
                        string3 = string3 + d2 + " - " + d3;
                        if (this.allowToShowCPW) {
                            this.setDestOptimalIntRange(string3);
                        } else {
                            this.setDestOptimalIntRange("");
                        }
                    }
                }
            }
            if (this.destLparKey != null) {
                this.debug("refreshing DestOptimalIntRange  ");
                this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".DestOptimalIntRange");
            }
        }
    }

    public double getSourceAmtToMoveProcs() {
        return this.m_dSourceAmtToMoveProcs;
    }

    public void setSourceAfterMoveProcs(double d) throws IllegalUserDataException {
        this.m_dSourceAfterMoveProcs = d;
    }

    public double getSourceAfterMoveIntPerf() {
        return this.m_dSourceAfterMoveIntPerf;
    }

    public void setSourceAfterMoveIntPerf(double d) throws IllegalUserDataException {
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dSourceAfterMoveIntPerf = 0.0;
        } else if (d > this.setFormat(this.toDouble(this.getSourceMaxIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMaxIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dSourceAfterMoveIntPerf = 0.0;
        } else if (d < this.setFormat(this.toDouble(this.getSourceMinIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MIN_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is smaller than the minimum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMinIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dSourceAfterMoveIntPerf = 0.0;
        } else {
            this.m_dSourceAfterMoveIntPerf = d;
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveIntPerf");
    }

    public double getSourceAfterMoveProcs() {
        return this.m_dSourceAfterMoveProcs;
    }

    public void setSourceMinIntPerf(String string) throws IllegalUserDataException {
        this.m_sSourceMinIntPerf = string;
    }

    public String getSourceMinIntPerf() {
        return this.m_sSourceMinIntPerf;
    }

    public void setSourceMaxIntPerf(String string) throws IllegalUserDataException {
        this.m_sSourceMaxIntPerf = string;
    }

    public String getSourceMaxIntPerf() {
        return this.m_sSourceMaxIntPerf;
    }

    public void setSourceCurrentIntPerf(double d) throws IllegalUserDataException {
        this.m_dSourceCurrentIntPerf = d;
    }

    public double getSourceCurrentIntPerf() {
        return this.m_dSourceCurrentIntPerf;
    }

    public ValueDescriptor[] getMoveToList() {
        return this.m_cdMoveTo;
    }

    public String getMoveTo() throws IllegalUserDataException {
        return this.m_sMoveTo;
    }

    public void setMoveTo(String string) throws IllegalUserDataException {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.m_sMoveTo = string;
        try {
            this.debug("in setMoveTo : " + string);
            this.debug("getMoveTo : " + this.getMoveTo());
            this.debug("mUsrNames : " + this.mUsrNames.toString());
            this.debug("mIntName : " + this.mIntNames.toString());
            String string2 = this.getMoveTo();
            string2 = string2.substring(0, string2.lastIndexOf("("));
            this.debug("destLparName : " + string2);
            this.destLparKey = (String)this.mIntNames.elementAt(this.mUsrNames.indexOf(string2.trim()));
            this.debug("destLparKey : " + this.destLparKey);
            this.destPartType = this.loadDataFromServer0("getPartitionType", this.destLparKey);
            Hashtable hashtable = this.loadDataFromServer("getProcessorData", this.destLparKey);
            this.destProcMode = (Short)hashtable.get("CurProcMode");
            int n = 0;
            int n2 = 0;
            if (255 == this.destProcMode) {
                long l = (Long)hashtable.get("CurAvailProcUnits");
                int n3 = (Integer)hashtable.get("CurMaxProcs");
                int n4 = (Integer)hashtable.get("CurMinProcs");
                int n5 = (Integer)hashtable.get("CurAllocProcs");
                this.debug("maxProcs = " + n3 + " , minProcs = " + n4 + " , curProcs = " + n5);
                if (this.OS400_PARTITION.equals(this.destPartType)) {
                    n = (Integer)hashtable.get("CurMinInteractivePerf");
                    n2 = (Integer)hashtable.get("CurMaxInteractivePerf");
                    this.destCurIntPerf = ((Integer)hashtable.get("CurAllocInteractivePerf")).intValue();
                }
                this.setDestMinProcs(Integer.toString(n4));
                this.setDestMaxProcs(Integer.toString(n3));
                this.setDestCurrentProcs(Integer.toString(n5));
                this.setDestAfterMoveProcs(Integer.toString(n5));
                this.mDestAddNum = n3 - n5;
                if ((long)this.mDestAddNum > l) {
                    this.mDestAddNum = (int)l;
                }
                if (this.mDestAddNum < 0) {
                    this.mDestAddNum = 0;
                }
            } else {
                double d = ((Long)hashtable.get("CurAvailProcUnits")).longValue();
                double d2 = ((Long)hashtable.get("CurMaxProcUnits")).longValue();
                double d3 = ((Long)hashtable.get("CurMinProcUnits")).longValue();
                double d4 = ((Long)hashtable.get("CurAllocProcUnits")).longValue();
                int n6 = (Integer)hashtable.get("CurMinProcs");
                int n7 = (Integer)hashtable.get("CurMaxProcs");
                this.destCurVirProcs = ((Integer)hashtable.get("CurAllocProcs")).intValue();
                this.destSharingMode = ((Short)hashtable.get("CurSharingMode")).intValue();
                this.destCurUncappedWeight = (Integer)hashtable.get("CurUncappedWeight");
                this.setDestMinProcUnits(Double.toString(d3 / 100.0));
                this.setDestMaxProcUnits(Double.toString(d2 / 100.0));
                this.setDestCurrentProcUnits(Double.toString(d4 / 100.0));
                this.setDestAfterMoveProcUnits(Double.toString(d4 / 100.0));
                this.setDestMinVirProc(Integer.toString(n6));
                this.setDestCurrentVirProc(this.destCurVirProcs);
                this.setDestAfterMoveVirProc(Double.toString(this.setFormat(this.destCurVirProcs)));
                this.setDestMaxVirProc(Integer.toString(n7));
                if (this.destSharingMode == 1.0) {
                    this.setDestCurrentUncappedWeight(this.destCurUncappedWeight);
                }
                this.mDestAddProcUnitsNum = d2 - d4;
                if (this.mDestAddProcUnitsNum > d) {
                    this.mDestAddProcUnitsNum = d;
                }
                if (this.mDestAddProcUnitsNum < 0.0) {
                    this.mDestAddProcUnitsNum = 0.0;
                }
                if (this.OS400_PARTITION.equals(this.partType)) {
                    n = (Integer)hashtable.get("CurMinInteractivePerf");
                    n2 = (Integer)hashtable.get("CurMaxInteractivePerf");
                    int n8 = (Integer)hashtable.get("CurAllocInteractivePerf");
                    this.destCurIntPerf = n8;
                }
            }
            if (this.OS400_PARTITION.equals(this.partType) && !this.allowToShowCPW) {
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceMinIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceCurrentIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceAfterMoveIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
            }
            this.debug("minIntPerf = " + n + " , maxIntPerf = " + n2 + " , curIntPerf = " + this.destCurIntPerf);
            if (n >= 0) {
                this.setDestMinIntPerf(Double.toString(n / 100));
            }
            if (n2 >= 0) {
                this.setDestMaxIntPerf(Double.toString(n2 / 100));
            }
            if (this.destCurIntPerf >= 0.0) {
                this.setDestCurrentIntPerf(this.destCurIntPerf / 100.0);
            }
            this.debug("destPartType = " + this.destPartType + " and  dest prco mode : " + this.destProcMode);
            if (this.RPA_PARTITION.equals(this.destPartType.trim()) && 255 == this.destProcMode) {
                this.destIsRPADedicated();
            } else if (this.RPA_PARTITION.equals(this.destPartType.trim()) && 255 != this.destProcMode) {
                this.destIsRPAShared();
                if (this.phypConfigProcUnits < 100) {
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestUncappedCheckbox", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestUncappedWeight", false);
                }
            } else if (this.OS400_PARTITION.equals(this.destPartType.trim()) && 255 == this.destProcMode) {
                this.destIsOS400Dedicated();
                if (!this.allowToShowCPW) {
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestMaxIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestCurrentIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestAfterMoveIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestOptimalIntRange", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".destIntRangeButton", false);
                }
            } else if (this.OS400_PARTITION.equals(this.destPartType.trim()) && 255 != this.destProcMode) {
                this.destIsOS400Shared();
                if (!this.allowToShowCPW) {
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestMaxIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestCurrentIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestAfterMoveIntPerf", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestOptimalIntRange", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".destIntRangeButton", false);
                }
                if (this.phypConfigProcUnits < 100) {
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestUncappedCheckbox", false);
                    this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".DestUncappedWeight", false);
                }
            }
            if (this.mAction.equals("move")) {
                if (this.allowToShowCPW) {
                    this.setPHYPIntRangeValues("destIntRangeButton", "bringup");
                }
                if (this.destSharingMode == 1.0) {
                    this.setDestUncapped(true);
                    this.setDestUncappedWeight(this.destCurUncappedWeight);
                    this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".DestUncappedCheckbox");
                } else {
                    this.setDestUncapped(false);
                    this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".DestUncappedCheckbox");
                }
                this.debug("checking source sharingMode");
                if (this.sharingMode == 1) {
                    this.debug("setting to TRUE");
                    this.setSourceUncapped(true);
                    this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                } else if (255 != this.procMode) {
                    this.debug("setting to FALSE");
                    this.setSourceUncapped(false);
                    this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                }
                if (255 == this.procMode) {
                    this.mUsrTaskMgr.storeElement(this.mCurrentPanel + ".SourceAmtToMoveProcs");
                } else {
                    this.mUsrTaskMgr.storeElement(this.mCurrentPanel + ".SourceAmtToMoveProcUnits");
                    if (this.OS400_PARTITION.equals(this.partType)) {
                        this.mUsrTaskMgr.storeElement(this.mCurrentPanel + ".SourceAfterMoveVirProc");
                    } else {
                        this.mUsrTaskMgr.storeElement(this.mCurrentPanel + ".AfterMoveVirProc");
                    }
                }
            }
            if (this.OS400_PARTITION.equals(this.partType) && !this.allowToShowCPW) {
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceMinIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceCurrentIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceAfterMoveIntPerf", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
            }
        }
        catch (Exception exception) {
            HSCLogUtils.clientLog(exception, HSCLogUtils._DLPARClassLogInfo);
            this.debug(exception.toString());
            this.showInfo(exception.toString(), null, null);
            return;
        }
    }

    public void setDestMinProcUnits(String string) throws IllegalUserDataException {
        this.m_sDestMinProcUnits = string;
    }

    public String getDestMinProcUnits() {
        return this.m_sDestMinProcUnits;
    }

    public void setDestMaxProcUnits(String string) throws IllegalUserDataException {
        this.m_sDestMaxProcUnits = string;
    }

    public String getDestMaxProcUnits() {
        return this.m_sDestMaxProcUnits;
    }

    public void setDestCurrentProcUnits(String string) throws IllegalUserDataException {
        this.m_sDestCurrentProcUnits = string;
    }

    public String getDestCurrentProcUnits() {
        return this.m_sDestCurrentProcUnits;
    }

    public void setDestAfterMoveProcUnits(String string) throws IllegalUserDataException {
        this.m_sDestAfterMoveProcUnits = string;
    }

    public String getDestAfterMoveProcUnits() {
        return this.m_sDestAfterMoveProcUnits;
    }

    public void setDestOptimalIntRange(String string) throws IllegalUserDataException {
        this.m_sDestOptimalIntRange = this.allowToShowCPW ? string : "";
    }

    public String getDestOptimalIntRange() {
        return this.m_sDestOptimalIntRange;
    }

    public void setSourceOptimalIntRange(String string) throws IllegalUserDataException {
        this.m_sSourceOptimalIntRange = this.allowToShowCPW ? string : "";
    }

    public String getSourceOptimalIntRange() {
        return this.m_sSourceOptimalIntRange;
    }

    public void setDestAfterMoveIntPerf(double d) throws IllegalUserDataException {
        this.debug("setDestAfterMoveIntPerf() : " + d);
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dDestAfterMoveIntPerf = 0.0;
        } else if (d > this.setFormat(this.toDouble(this.getDestMaxIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_INT_PERF_REMOVE", "You have attempted to set {0} interactive performance, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dDestAfterMoveIntPerf = 0.0;
        } else if (d < this.setFormat(this.toDouble(this.getDestMinIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MIN_INT_PERF_REMOVE", "You have attempted to set {0} interactive performance, which is smaller than the minimum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMinIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dDestAfterMoveIntPerf = 0.0;
        } else {
            this.m_dDestAfterMoveIntPerf = d;
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveIntPerf");
    }

    public double getDestAfterMoveIntPerf() {
        return this.m_dDestAfterMoveIntPerf;
    }

    public void setSourceAfterMoveVirProc(double d) throws IllegalUserDataException {
        this.debug("setSourceAfterMoveVirProc : " + d);
        if (d > this.setFormat(this.getSourceCurrentVirProc() - this.setFormat(this.toDouble(this.getSourceMinVirProc())))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMaxVirProc()))});
            this.showInfo(this.msg, null, null);
            this.m_dSourceAfterMoveVirProc = 0.0;
            this.m_sDestAfterMoveVirProc = Double.toString(this.setFormat(this.getDestCurrentVirProc()));
        } else {
            if (255 != this.destProcMode) {
                String string = this.getMoveTo();
                if (string != null && string.trim().length() > 0 && d > this.setFormat(this.toDouble(this.getDestMaxVirProc()) - this.getDestCurrentVirProc())) {
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxVirProc()) - this.getDestCurrentVirProc())});
                    this.showInfo(this.msg, null, null);
                    this.m_dSourceAfterMoveVirProc = 0.0;
                    this.m_sDestAfterMoveVirProc = Double.toString(this.setFormat(this.getDestCurrentVirProc()));
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveVirProc");
                } else if (string != null && string.trim().length() > 0) {
                    this.setDestAfterMoveVirProc(Double.toString(this.setFormat(this.getDestCurrentVirProc() + d)));
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveVirProc");
                }
            }
            this.m_dSourceAfterMoveVirProc = d;
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveVirProc");
    }

    public double getSourceAfterMoveVirProc() {
        return this.m_dSourceAfterMoveVirProc;
    }

    public void setDestMinIntPerf(String string) throws IllegalUserDataException {
        this.m_sDestMinIntPerf = string;
    }

    public String getDestMinIntPerf() {
        return this.m_sDestMinIntPerf;
    }

    public void setDestMaxIntPerf(String string) throws IllegalUserDataException {
        this.m_sDestMaxIntPerf = string;
    }

    public String getDestMaxIntPerf() {
        return this.m_sDestMaxIntPerf;
    }

    public void setDestCurrentIntPerf(double d) throws IllegalUserDataException {
        this.m_dDestCurrentIntPerf = d;
    }

    public double getDestCurrentIntPerf() {
        return this.m_dDestCurrentIntPerf;
    }

    public void setDestMinProcs(String string) throws IllegalUserDataException {
        this.m_sDestMinProcs = string;
    }

    public String getDestMinProcs() {
        return this.m_sDestMinProcs;
    }

    public void setDestMaxProcs(String string) throws IllegalUserDataException {
        this.m_sDestMaxProcs = string;
    }

    public String getDestMaxProcs() {
        return this.m_sDestMaxProcs;
    }

    public void setDestCurrentProcs(String string) throws IllegalUserDataException {
        this.m_sDestCurrentProcs = string;
    }

    public String getDestCurrentProcs() {
        return this.m_sDestCurrentProcs;
    }

    public void setDestAfterMoveProcs(String string) throws IllegalUserDataException {
        this.m_sDestAfterMoveProcs = string;
    }

    public String getDestAfterMoveProcs() {
        return this.m_sDestAfterMoveProcs;
    }

    public void setDestMinVirProc(String string) throws IllegalUserDataException {
        this.m_sDestMinVirProc = string;
    }

    public String getDestMinVirProc() {
        return this.m_sDestMinVirProc;
    }

    public void setDestMaxVirProc(String string) throws IllegalUserDataException {
        this.m_sDestMaxVirProc = string;
    }

    public String getDestMaxVirProc() {
        return this.m_sDestMaxVirProc;
    }

    public void setDestCurrentVirProc(double d) throws IllegalUserDataException {
        this.m_dDestCurrentVirProc = d;
    }

    public double getDestCurrentVirProc() {
        return this.m_dDestCurrentVirProc;
    }

    public void setDestAfterMoveVirProc(String string) throws IllegalUserDataException {
        this.debug("setDestAfterMoveVirProc : " + string);
        this.m_sDestAfterMoveVirProc = string;
    }

    public String getDestAfterMoveVirProc() {
        return this.m_sDestAfterMoveVirProc;
    }

    public void setSourceMinProcUnits(String string) throws IllegalUserDataException {
        this.m_sSourceMinProcUnits = string;
    }

    public String getSourceMinProcUnits() {
        return this.m_sSourceMinProcUnits;
    }

    public void setSourceMaxProcUnits(String string) throws IllegalUserDataException {
        this.m_sSourceMaxProcUnits = string;
    }

    public String getSourceMaxProcUnits() {
        return this.m_sSourceMaxProcUnits;
    }

    public void setSourceCurrentProcUnits(String string) throws IllegalUserDataException {
        this.m_sSourceCurrentProcUnits = string;
    }

    public String getSourceCurrentProcUnits() {
        return this.m_sSourceCurrentProcUnits;
    }

    public void setSourceAmtToMoveProcUnits(double d) throws IllegalUserDataException {
        this.debug("setSourceAmtToMoveProcUnits()");
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dSourceAmtToMoveProcUnits = 0.0;
        } else if (d > this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()) - this.toDouble(this.getSourceMinProcUnits()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()) - this.toDouble(this.getSourceMinProcUnits()))});
            this.showInfo(this.msg, null, null);
            this.m_dSourceAmtToMoveProcUnits = 0.0;
        } else {
            this.m_dSourceAmtToMoveProcUnits = d;
            String string = this.getMoveTo();
            if (255 == this.destProcMode) {
                this.debug("checking for processing units should be multiples of 100");
                if (Math.IEEEremainder(d, 1.0) != 0.0) {
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_CPU_PROC_UNIT_100", "Processing units {0} should be multiples of 1", new String[]{"" + d});
                    this.showInfo(this.msg, null, null);
                    this.m_dSourceAmtToMoveProcUnits = 0.0;
                    this.m_dSourceAfterMoveProcUnits = this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()));
                    this.m_sDestAfterMoveProcs = this.getDestCurrentProcs();
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveProcs");
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcUnits");
                } else if (this.setFormat(this.toDouble(this.getDestMaxProcs()) - this.toDouble(this.getDestCurrentProcs())) >= d) {
                    this.m_dSourceAfterMoveProcUnits = this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()) - d);
                    this.debug("m_dSourceAfterMoveProcUnits = " + this.m_dSourceAfterMoveProcUnits);
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcUnits");
                    if (string != null && string.trim().length() > 0) {
                        this.m_sDestAfterMoveProcs = Double.toString(this.setFormat(this.toDouble(this.getDestCurrentProcs()) + d));
                        this.debug("m_sDestAfterMoveProcs = " + this.m_sDestAfterMoveProcs);
                        this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveProcs");
                    }
                } else if (string != null && string.trim().length() > 0) {
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_MOVE", "You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxProcs()) - this.toDouble(this.getDestCurrentProcs()))});
                    this.showInfo(this.msg, null, null);
                    this.m_dSourceAmtToMoveProcUnits = 0.0;
                    this.m_dSourceAfterMoveProcUnits = this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()));
                }
            } else if (this.setFormat(this.toDouble(this.getDestMaxProcUnits()) - this.toDouble(this.getDestCurrentProcUnits())) >= d) {
                this.m_dSourceAfterMoveProcUnits = this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()) - d);
                this.debug("m_dSourceAfterMoveProcUnits = " + this.m_dSourceAfterMoveProcUnits);
                this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcUnits");
                if (string != null && string.trim().length() > 0) {
                    this.m_sDestAfterMoveProcUnits = Double.toString(this.setFormat(this.toDouble(this.getDestCurrentProcUnits()) + d));
                    this.debug("m_sDestAfterMoveProcUnits = " + this.m_sDestAfterMoveProcUnits);
                    this.refreshAndReturn(this.mCurrentMoveToPanel + ".DestAfterMoveProcUnits");
                }
            } else if (string != null && string.trim().length() > 0) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_MOVE", "You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getDestMaxProcUnits()) - this.toDouble(this.getDestCurrentProcUnits()))});
                this.showInfo(this.msg, null, null);
                this.m_dSourceAmtToMoveProcUnits = 0.0;
                this.m_dSourceAfterMoveProcUnits = this.setFormat(this.toDouble(this.getSourceCurrentProcUnits()));
            }
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAmtToMoveProcUnits");
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".SourceAfterMoveProcUnits");
    }

    public double getSourceAmtToMoveProcUnits() {
        return this.m_dSourceAmtToMoveProcUnits;
    }

    public void setSourceAfterMoveProcUnits(double d) throws IllegalUserDataException {
        this.m_dSourceAfterMoveProcUnits = d;
    }

    public double getSourceAfterMoveProcUnits() {
        return this.m_dSourceAfterMoveProcUnits;
    }

    public void setSourceMinVirProc(String string) throws IllegalUserDataException {
        this.m_sSourceMinVirProc = string;
    }

    public String getSourceMinVirProc() {
        return this.m_sSourceMinVirProc;
    }

    public void setSourceMaxVirProc(String string) throws IllegalUserDataException {
        this.m_sSourceMaxVirProc = string;
    }

    public String getSourceMaxVirProc() {
        return this.m_sSourceMaxVirProc;
    }

    public void setSourceCurrentUncappedWeight(double d) throws IllegalUserDataException {
        if (d > 255.0 || d < 0.0) {
            this.showInfo(this.ERR_UNCAPPED_RANGE, null, null);
        } else {
            this.m_dSourceCurrentUncappedWeight = d;
        }
    }

    public void setSourceUncappedWeight(double d) throws IllegalUserDataException {
        if (d > 255.0 || d < 0.0) {
            this.showInfo(this.ERR_UNCAPPED_RANGE, null, null);
        } else {
            this.m_dSourceUncappedWeight = d;
        }
    }

    public double getSourceCurrentUncappedWeight() {
        return this.m_dSourceCurrentUncappedWeight;
    }

    public void setSourceCurrentVirProc(double d) throws IllegalUserDataException {
        this.m_dSourceCurrentVirProc = d;
    }

    public double getSourceCurrentVirProc() {
        return this.m_dSourceCurrentVirProc;
    }

    public double getSourceUncappedWeight() {
        return this.m_dSourceUncappedWeight;
    }

    public void setSourceAmtToMoveVirProc(double d) throws IllegalUserDataException {
        this.m_dSourceAmtToMoveVirProc = d;
    }

    public double getSourceAmtToMoveVirProc() {
        return this.m_dSourceAmtToMoveVirProc;
    }

    public void setDestUncappedWeight(double d) throws IllegalUserDataException {
        if (d > 255.0 || d < 0.0) {
            this.showInfo(this.ERR_UNCAPPED_RANGE, null, null);
        } else {
            this.m_dDestUncappedWeight = d;
        }
    }

    public double getDestUncappedWeight() {
        return this.m_dDestUncappedWeight;
    }

    public void setDestUncapped(boolean bl) {
        this.m_bDestUncapped = bl;
    }

    public boolean getDestUncapped() {
        return this.m_bDestUncapped;
    }

    public boolean isDestUncapped() {
        return this.m_bDestUncapped;
    }

    public void setSourceUncapped(boolean bl) {
        this.m_bSourceUncapped = bl;
    }

    public boolean getSourceUncapped() {
        return this.m_bSourceUncapped;
    }

    public boolean isSourceUncapped() {
        return this.m_bSourceUncapped;
    }

    public double getDestCurrentUncappedWeight() {
        return this.m_dDestUncappedWeight;
    }

    public void setDestCurrentUncappedWeight(double d) throws IllegalUserDataException {
        if (d > 255.0 || d < 0.0) {
            this.showInfo(this.ERR_UNCAPPED_RANGE, null, null);
        } else {
            this.m_dDestUncappedWeight = d;
        }
    }

    public String getDestProcs() {
        return this.m_sDestProcs;
    }

    public void setDestProcs(String string) {
        this.m_sDestProcs = string;
    }

    public void setMaxProcs(String string) throws IllegalUserDataException {
        this.m_sMaxProcs = string;
    }

    public String getMaxProcs() {
        this.debug("in getMaxProcs()");
        return this.m_sMaxProcs;
    }

    public void setCurrentProcs(String string) throws IllegalUserDataException {
        this.m_sCurrentProcs = string;
    }

    public String getCurrentProcs() {
        this.debug("in getCurrentProcs()");
        return this.m_sCurrentProcs;
    }

    public void setAmtToAddProcs(double d) throws IllegalUserDataException {
        if (!this.mfgDefConfig) {
            this.debug("in setAmtToAddProcs");
            if (d > this.setFormat(this.toDouble(this.getMaxProcs()) - this.toDouble(this.getCurrentProcs()))) {
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxProcs()) - this.toDouble(this.getCurrentProcs()))});
                this.showInfo(this.msg, null, null);
                this.m_dAmtToAddProcs = 0.0;
            } else {
                this.m_dAmtToAddProcs = d;
                this.m_dAfterAddProcs = this.setFormat(this.m_dAmtToAddProcs + this.toDouble(this.getCurrentProcs()));
                this.refreshAndReturn(this.mCurrentAddPanel + ".AfterAddProcs");
            }
        } else {
            this.m_dAmtToAddProcs = d;
        }
        this.refreshAndReturn(this.mCurrentAddPanel + ".AmtToAddProcs");
    }

    public double getAmtToAddProcs() {
        return this.m_dAmtToAddProcs;
    }

    public void setAfterAddProcs(double d) throws IllegalUserDataException {
        this.m_dAfterAddProcs = d;
    }

    public double getAfterAddProcs() {
        return this.m_dAfterAddProcs;
    }

    public void setMinProcs(String string) throws IllegalUserDataException {
        this.m_sMinProcs = string;
    }

    public String getMinProcs() {
        return this.m_sMinProcs;
    }

    public void setAfterRemoveIntPerf(double d) throws IllegalUserDataException {
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dAfterRemoveIntPerf = 0.0;
            this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveIntPerf");
        } else if (d > this.setFormat(this.toDouble(this.getMaxIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMaxIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterRemoveIntPerf = 0.0;
        } else if (d < this.setFormat(this.toDouble(this.getMinIntPerf()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MIN_INT_PERF_REMOVE", "You have attempted to remove {0} interactive performance, which is smaller than the minimum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getSourceMinIntPerf()))});
            this.showInfo(this.msg, null, null);
            this.m_dAfterRemoveIntPerf = 0.0;
        } else {
            this.m_dAfterRemoveIntPerf = d;
        }
        this.refreshAndReturn(this.mCurrentRemovePanel + ".AfterRemoveIntPerf");
    }

    public double getAfterRemoveIntPerf() {
        return this.m_dAfterRemoveIntPerf;
    }

    public void setAmtToMoveProcUnits(double d) throws IllegalUserDataException {
        this.debug("setAmtToMoveProcUnits()");
        if (d < 0.0) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_NEG_VALUE", "Enter a positive value");
            this.showInfo(this.msg, null, null);
            this.m_dAmtToMoveProcUnits = 0.0;
            this.m_sAfterMoveProcUnits = this.formatDoubleToString(this.setFormat(this.toDouble(this.getCurrentProcUnits())));
            this.refreshAndReturn(this.mCurrentMoveToPanel + ".AmtToMoveProcUnits");
        } else if (d > this.setFormat(this.toDouble(this.getMaxProcUnits()) - this.toDouble(this.getCurrentProcUnits()))) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + d, "" + this.setFormat(this.toDouble(this.getMaxProcUnits()) - this.toDouble(this.getCurrentProcUnits()))});
            this.showInfo(this.msg, null, null);
            this.m_dAmtToMoveProcUnits = 0.0;
            this.m_sAfterMoveProcUnits = this.formatDoubleToString(this.setFormat(this.toDouble(this.getCurrentProcUnits())));
            this.refreshAndReturn(this.mCurrentMoveToPanel + ".AmtToMoveProcUnits");
        } else {
            this.m_dAmtToMoveProcUnits = d;
            this.m_sAfterMoveProcUnits = this.formatDoubleToString(this.m_dAmtToMoveProcUnits + this.toDouble(this.getCurrentProcUnits()));
            this.refreshAndReturn(this.mCurrentMoveToPanel + ".AmtToMoveProcUnits");
        }
        this.refreshAndReturn(this.mCurrentMoveToPanel + ".AmtToMoveProcUnits");
    }

    public double getAmtToMoveProcUnits() {
        return this.m_dAmtToMoveProcUnits;
    }

    public void setAfterMoveProcUnits(String string) throws IllegalUserDataException {
        this.m_sAfterMoveProcUnits = string;
    }

    public String getAfterMoveProcUnits() {
        return this.m_sAfterMoveProcUnits;
    }

    public void setDestCuurentProcUnits(String string) throws IllegalUserDataException {
        this.m_sDestCuurentProcUnits = string;
    }

    public String getDestCuurentProcUnits() {
        return this.m_sDestCuurentProcUnits;
    }

    public double getDetail() {
        return this.m_dDetail;
    }

    public void setDetail(double d) throws IllegalUserDataException {
        this.m_dDetail = d;
    }

    public double getTimeout() {
        return this.m_dTimeout;
    }

    public void setTimeout(double d) throws IllegalUserDataException {
        this.m_dTimeout = d;
    }

    public String getDetailLevel() {
        return this.m_sDetailLevel;
    }

    public void setDetailLevel(String string) throws IllegalUserDataException {
        this.m_sDetailLevel = string;
    }

    public ValueDescriptor[] getDetailLevelList() {
        return this.m_cdDetailLevel;
    }

    public ValueDescriptor[] getDetailList() {
        return this.m_cdDetail;
    }

    public ValueDescriptor[] getTimeoutList() {
        return this.m_cdTimeout;
    }

    public void save() {
    }

    public void load() {
        this.m_sMaxProcessors = "";
        this.m_sCurrentProcessors = "";
        this.m_dProcAmountToAdd = 0.0;
        this.m_dProdAfterAdd = 0.0;
        this.m_sMaxIntPerf = "";
        this.m_sCurrentIntPerf = "";
        this.m_dAmtToAddIntPerf = 0.0;
        this.m_dAfterAddIntPerf = 0.0;
        this.m_dDetail = 1.0;
        this.m_cdDetail = new ValueDescriptor[0];
        this.m_cdTimeout = new ValueDescriptor[0];
        this.m_cdMoveTo = new ValueDescriptor[0];
        this.m_dTimeout = 5.0;
        this.m_dSourceUncappedWeight = 128.0;
        this.m_dDestUncappedWeight = 128.0;
        this.m_dUncappedWeight = 128.0;
        this.loadBackendData();
    }

    private void loadBackendData() {
        this.debug("reaching loadBackendData()");
        try {
            this.debug("calling isMfgDefConfig() on Mobject");
            this.mfgDefConfig = this.loadDataFromServer2("isMfgDefConfig");
            this.debug("mfgDefConfig=" + this.mfgDefConfig);
            this.partType = this.loadDataFromServer1("getPartitionType");
            this.debug("partType=" + this.partType);
            Hashtable hashtable = this.loadDataFromServer("getProcessorData");
            this.debug("procValues=" + hashtable);
            this.allowToShowCPW = this.loadDataFromServer2("getAllowHMCAssignCPW");
            this.debug("allowToShowCPW=" + this.allowToShowCPW);
            if (hashtable != null) {
                this.procMode = (Short)hashtable.get("CurProcMode");
                this.debug("procMode=" + this.procMode);
                if (255 == this.procMode) {
                    long l = (Long)hashtable.get("CurAvailProcUnits");
                    int n = (Integer)hashtable.get("CurMaxProcs");
                    int n2 = (Integer)hashtable.get("CurMinProcs");
                    int n3 = (Integer)hashtable.get("CurAllocProcs");
                    if (this.OS400_PARTITION.equals(this.partType)) {
                        Integer n4 = (Integer)hashtable.get("CurMinInteractivePerf");
                        Integer n5 = (Integer)hashtable.get("CurMaxInteractivePerf");
                        Integer n6 = (Integer)hashtable.get("CurAllocInteractivePerf");
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        if (n4 != null) {
                            n7 = n4;
                        }
                        if (n5 != null) {
                            n8 = n5;
                        }
                        if (n6 != null) {
                            n9 = n6;
                        }
                        this.setMinIntPerf(Integer.toString(n7 / 100));
                        this.setMaxIntPerf(Integer.toString(n8 / 100));
                        this.setCurrentIntPerf(Integer.toString(n9 / 100));
                        this.setSourceMinIntPerf(Integer.toString(n7 / 100));
                        this.setSourceMaxIntPerf(Integer.toString(n8 / 100));
                        this.setSourceCurrentIntPerf(n9 / 100);
                    }
                    if (n3 <= n2) {
                        this.mCannotRemove = true;
                    }
                    if (l == 0L) {
                        this.mDisableAdd = true;
                    }
                    if (!this.mfgDefConfig && n3 >= n) {
                        this.mCannotAdd = true;
                    }
                    this.mRemoveNum = n3 - n2;
                    if (this.mRemoveNum == 0) {
                        this.mCannotRemove = true;
                    }
                    if (this.mRemoveNum < 0) {
                        this.mRemoveNum = 0;
                    }
                    this.mMoveNum = this.mRemoveNum;
                    this.mAddNum = n - n3;
                    if ((long)this.mAddNum > l) {
                        this.mAddNum = (int)l;
                    }
                    if (this.mAddNum < 0) {
                        this.mAddNum = 0;
                    }
                    if (this.OS400_PARTITION.equals(this.partType) && !this.mfgDefConfig) {
                        this.mCannotRemove = false;
                        this.mCannotAdd = false;
                    }
                    this.setFreeProcs(Long.toString(l));
                    this.setMaxProcs(Integer.toString(n));
                    this.setMinProcs(Integer.toString(n2));
                    this.setCurrentProcs(Integer.toString(n3));
                    this.setAfterAddProcs(n3);
                    this.setAfterRemoveProcs(n3);
                    this.setSourceMinProcs(Integer.toString(n2));
                    this.setSourceMaxProcs(Integer.toString(n));
                    this.setSourceCurrentProcs(Integer.toString(n3));
                    this.debug("curProcs=" + n3);
                    this.setSourceAfterMoveProcs(this.setFormat(n3));
                } else {
                    double d = ((Long)hashtable.get("CurAvailProcUnits")).longValue();
                    double d2 = ((Long)hashtable.get("CurMaxProcUnits")).longValue();
                    double d3 = ((Long)hashtable.get("CurMinProcUnits")).longValue();
                    double d4 = ((Long)hashtable.get("CurAllocProcUnits")).longValue();
                    int n = (Integer)hashtable.get("CurMinProcs");
                    int n10 = (Integer)hashtable.get("CurMaxProcs");
                    int n11 = (Integer)hashtable.get("CurAllocProcs");
                    this.sharingMode = ((Short)hashtable.get("CurSharingMode")).intValue();
                    this.curUncappedWeight = (Integer)hashtable.get("CurUncappedWeight");
                    this.debug("sharingMode=" + this.sharingMode);
                    this.debug("curUncappedWeight=" + this.curUncappedWeight);
                    if (this.sharingMode == 0) {
                        this.curUncappedWeight = 128;
                    }
                    if (this.OS400_PARTITION.equals(this.partType)) {
                        Integer n12 = (Integer)hashtable.get("CurMinInteractivePerf");
                        Integer n13 = (Integer)hashtable.get("CurMaxInteractivePerf");
                        Integer n14 = (Integer)hashtable.get("CurAllocInteractivePerf");
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        if (n12 != null) {
                            n15 = n12;
                        }
                        if (n13 != null) {
                            n16 = n13;
                        }
                        if (n14 != null) {
                            n17 = n14;
                        }
                        this.setMinIntPerf(Integer.toString(n15 / 100));
                        this.setMaxIntPerf(Integer.toString(n16 / 100));
                        this.setCurrentIntPerf(Integer.toString(n17 / 100));
                        this.setSourceMinIntPerf(Integer.toString(n15 / 100));
                        this.setSourceMaxIntPerf(Integer.toString(n16 / 100));
                        this.setSourceCurrentIntPerf(n17 / 100);
                    }
                    if (d4 <= d3 && n11 == n) {
                        this.mCannotRemove = true;
                    }
                    if (d == 0.0 && n11 == n10) {
                        this.mDisableAdd = true;
                    }
                    if (d4 >= d2 && n11 == n10) {
                        this.mCannotAdd = true;
                    }
                    this.mRemoveProcUnitsNum = d4 - d3;
                    if (this.mRemoveProcUnitsNum < 0.0) {
                        this.mRemoveProcUnitsNum = 0.0;
                    }
                    this.mMoveProcUnitsNum = this.mRemoveProcUnitsNum;
                    this.mAddProcUnitsNum = d2 - d4;
                    if ((double)((long)this.mAddProcUnitsNum) > d) {
                        this.mAddProcUnitsNum = d;
                    }
                    if (this.mAddProcUnitsNum < 0.0) {
                        this.mAddProcUnitsNum = 0.0;
                    }
                    this.setFreeProcs(Double.toString(d / 100.0));
                    this.debug("availProcUnits/100 = " + d / 100.0);
                    this.setMaxProcUnits(Double.toString(d2 / 100.0));
                    this.debug("maxProcUnits/100 = " + d2 / 100.0);
                    this.setMinProcUnits(Double.toString(d3 / 100.0));
                    this.debug("minProcUnits/100 = " + d3 / 100.0);
                    this.setCurrentProcUnits(Double.toString(d4 / 100.0));
                    this.debug("curProcUnits/100 = " + d4 / 100.0);
                    this.setAfterAddProcUnits(this.setFormat(d4 / 100.0));
                    this.setAfterRemoveProcUnits(Double.toString(this.setFormat(d4 / 100.0)));
                    this.setMinVirProc(Long.toString(n));
                    this.setMaxVirProc(Long.toString(n10));
                    this.setCurrentVirProc(Long.toString(n11));
                    this.setSourceMaxProcUnits(Double.toString(d2 / 100.0));
                    this.setSourceMinProcUnits(Double.toString(d3 / 100.0));
                    this.setSourceCurrentProcUnits(Double.toString(d4 / 100.0));
                    this.setSourceAfterMoveProcUnits(this.setFormat(d4 / 100.0));
                    this.setSourceMinVirProc(Long.toString(n));
                    this.setSourceMaxVirProc(Long.toString(n10));
                    this.setSourceCurrentVirProc(n11);
                    if (this.sharingMode == 1) {
                        this.setUncappedWeight(this.curUncappedWeight);
                    }
                    if (this.procMode == 0) {
                        this.setSourceUncappedWeight(this.curUncappedWeight);
                    }
                    this.phypConfigProcUnits = this.loadDataFromServer3("getConfigProcUnits");
                    if (this.OS400_PARTITION.equals(this.partType) && !this.mfgDefConfig) {
                        this.mCannotRemove = false;
                        this.mCannotAdd = false;
                    }
                }
                if (this.mfgDefConfig && !this.mAction.equals("move")) {
                    this.mCannotRemove = false;
                    this.mDisableAdd = false;
                    this.mCannotAdd = false;
                }
            }
            if (this.mAction.equals("move")) {
                Hashtable hashtable2 = this.loadDataFromServer("getMoveToPartitionName");
                this.debug("runLpars = " + hashtable2);
                if (hashtable2 != null) {
                    if (hashtable2.size() > 0) {
                        this.m_cdMoveTo = this.initMoveToData(hashtable2);
                        this.debug("m_cdMoveTo.length : " + this.m_cdMoveTo.length);
                        if (this.m_cdMoveTo.length == 0) {
                            this.mDisableMove = true;
                        }
                    } else {
                        this.mDisableMove = true;
                    }
                }
            }
            this.setDefTimeout();
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            this.mLoadException = throwable;
            this.handleException(throwable);
        }
    }

    public void setDynamicValues() {
        this.disablePanels();
        String string = "";
        double d = 0.0;
        String string2 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ADD_PROC", "Add Processor Resources");
        String string3 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "REMOVE_PROC", "Remove Processor Resources");
        String string4 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "MOVE_PROC", "Move Processor Resources");
        String string5 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "AIX", "AIX");
        String string6 = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "OS400", "OS400");
        String string7 = this.mLparKey.substring(0, this.mLparKey.indexOf("*"));
        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ADD_PROC", "Add Processor Resources"));
        this.debug("partType=" + this.partType);
        this.debug("procMode=" + this.procMode);
        if (this.mUsrTaskMgr != null) {
            if (this.RPA_PARTITION.equals(this.partType)) {
                if (255 == this.procMode) {
                    if (this.mAction.equals("add")) {
                        this.debug("in RPA Dedicated Add");
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string2 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuAddRPADedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuAddRPADedicated, true);
                        this.mCurrentAddPanel = this.mCurrentPanel = this.mCpuAddRPADedicated + "." + this.mCpuAddRPADedicated + "General";
                        string = ".AmtToAddProcs";
                        d = this.mAddNum;
                        this.enablePanel(this.mCpuAddRPADedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddRPADedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddRPADedicated + "." + "OptionsPanel.Number6", 29, "1092");
                    }
                    if (this.mAction.equals("remove")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string3 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuRemoveRPADedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveRPADedicated, true);
                        this.mCurrentRemovePanel = this.mCurrentPanel = this.mCpuRemoveRPADedicated + "." + this.mCpuRemoveRPADedicated + "General";
                        string = ".AmtToRemoveProcs";
                        d = this.mRemoveNum;
                        this.enablePanel(this.mCpuRemoveRPADedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveRPADedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveRPADedicated + "." + "OptionsPanel.Number6", 29, "1092");
                    }
                    if (this.mAction.equals("move")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string4 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuMoveRPADedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuMoveRPADedicated, true);
                        this.mCurrentMoveToPanel = this.mCurrentPanel = this.mCpuMoveRPADedicated + "." + this.mCpuMoveRPADedicated + "General";
                        string = ".SourceAmtToMoveProcs";
                        d = this.mMoveNum;
                        this.enablePanel(this.mCpuMoveRPADedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveRPADedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveRPADedicated + "." + "OptionsPanel.Number6", 29, "1092");
                    }
                    if (!this.mfgDefConfig) {
                        this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                        this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                    }
                } else {
                    if (this.mAction.equals("add")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string2 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuAddRPAShared);
                        this.mUsrTaskMgr.setShown(this.mCpuAddRPAShared, true);
                        this.mCurrentAddPanel = this.mCurrentPanel = this.mCpuAddRPAShared + "." + this.mCpuAddRPAShared + "General";
                        this.enablePanel(this.mCpuAddRPAShared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddRPAShared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddRPAShared + "." + "OptionsPanel.Number6", 29, "1092");
                        string = ".AfterAddVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.toDouble(this.getMaxVirProc()) - this.toDouble(this.getCurrentVirProc()));
                            this.debug("getMaxVirProc() - getMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                    }
                    if (this.mAction.equals("remove")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string3 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuRemoveRPAShared);
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveRPAShared, true);
                        this.mCurrentRemovePanel = this.mCurrentPanel = this.mCpuRemoveRPAShared + "." + this.mCpuRemoveRPAShared + "General";
                        this.enablePanel(this.mCpuRemoveRPAShared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveRPAShared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveRPAShared + "." + "OptionsPanel.Number6", 29, "1092");
                        string = ".AfterRemoveVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.toDouble(this.getCurrentVirProc()) - this.toDouble(this.getMinVirProc()));
                            this.debug("getMaxVirProc() - getMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                    }
                    if (this.mAction.equals("move")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string4 + " - " + string5 + " (" + string7 + ")");
                        this.debug(this.mCpuMoveRPAShared);
                        this.mUsrTaskMgr.setShown(this.mCpuMoveRPAShared, true);
                        this.mCurrentMoveToPanel = this.mCurrentPanel = this.mCpuMoveRPAShared + "." + this.mCpuMoveRPAShared + "General";
                        this.enablePanel(this.mCpuMoveRPAShared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveRPAShared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveRPAShared + "." + "OptionsPanel.Number6", 29, "1092");
                        string = ".AfterMoveVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.getSourceCurrentVirProc() - this.toDouble(this.getSourceMinVirProc()));
                            this.debug("getSourceMaxVirProc() - getSourceMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                    }
                    this.debug("RPA Shared : reaching uncapped check box = " + this.mCurrentPanel);
                    if (this.sharingMode == 1) {
                        this.debug("reaching uncapped check box set to TRUE");
                        if (!this.mAction.equals("move")) {
                            this.setUncapped(true);
                            this.setUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".UncappedCheckbox");
                        } else {
                            this.setSourceUncapped(true);
                            this.setSourceUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                        }
                    } else {
                        this.debug("reaching uncapped check box set to FALSE");
                        if (!this.mAction.equals("move")) {
                            this.setUncapped(false);
                            this.setUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".UncappedCheckbox");
                        } else {
                            this.setSourceUncapped(false);
                            this.setSourceUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                        }
                    }
                    this.debug("reaching phypConfigProcUnits check=" + this.phypConfigProcUnits);
                    if (this.phypConfigProcUnits < 100) {
                        if (!this.mAction.equals("move")) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".UncappedCheckbox", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".UncappedWeight", false);
                        } else {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceUncappedCheckbox", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceUncappedWeight", false);
                        }
                    }
                }
            } else if (this.OS400_PARTITION.equals(this.partType)) {
                if (255 == this.procMode) {
                    if (this.mAction.equals("add")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string2 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuAddOS400Dedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuAddOS400Dedicated, true);
                        this.mCurrentAddPanel = this.mCurrentPanel = this.mCpuAddOS400Dedicated + "." + this.mCpuAddOS400Dedicated + "General";
                        string = ".AmtToAddProcs";
                        d = this.mAddNum;
                        this.enablePanel(this.mCpuAddOS400Dedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddOS400Dedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddOS400Dedicated + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuAddOS400Dedicated + "." + "OptionsPanel.detailCombo", false);
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".IntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".MaxIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".CurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".AfterAddIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    if (this.mAction.equals("remove")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string3 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuRemoveOS400Dedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveOS400Dedicated, true);
                        this.mCurrentRemovePanel = this.mCurrentPanel = this.mCpuRemoveOS400Dedicated + "." + this.mCpuRemoveOS400Dedicated + "General";
                        string = ".AmtToRemoveProcs";
                        d = this.mRemoveNum;
                        this.enablePanel(this.mCpuRemoveOS400Dedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveOS400Dedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveOS400Dedicated + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveOS400Dedicated + "." + "OptionsPanel.detailCombo", false);
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".IntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".MinIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".CurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".AmtToRemoveIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    if (this.mAction.equals("move")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string4 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuMoveOS400Dedicated);
                        this.mUsrTaskMgr.setShown(this.mCpuMoveOS400Dedicated, true);
                        this.mCurrentMoveToPanel = this.mCurrentPanel = this.mCpuMoveOS400Dedicated + "." + this.mCpuMoveOS400Dedicated + "General";
                        string = ".SourceAmtToMoveProcs";
                        d = this.mMoveNum;
                        this.enablePanel(this.mCpuMoveOS400Dedicated);
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveOS400Dedicated + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveOS400Dedicated + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuMoveOS400Dedicated + "." + "OptionsPanel.detailCombo", false);
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceMinIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceCurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceAfterMoveIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    if (!this.mfgDefConfig) {
                        this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                        this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                    }
                } else {
                    if (this.mAction.equals("add")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string2 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuAddOS400Shared);
                        this.mUsrTaskMgr.setShown(this.mCpuAddOS400Shared, true);
                        this.mCurrentAddPanel = this.mCurrentPanel = this.mCpuAddOS400Shared + "." + this.mCpuAddOS400Shared + "General";
                        this.enablePanel(this.mCpuAddOS400Shared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddOS400Shared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuAddOS400Shared + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuAddOS400Shared + "." + "OptionsPanel.detailCombo", false);
                        string = ".AfterAddVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.toDouble(this.getMaxVirProc()) - this.toDouble(this.getCurrentVirProc()));
                            this.debug("getMaxVirProc() - getMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".IntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".MaxIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".CurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".AfterAddIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    if (this.mAction.equals("remove")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string3 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuRemoveOS400Shared);
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveOS400Shared, true);
                        this.mCurrentRemovePanel = this.mCurrentPanel = this.mCpuRemoveOS400Shared + "." + this.mCpuRemoveOS400Shared + "General";
                        this.enablePanel(this.mCpuRemoveOS400Shared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveOS400Shared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuRemoveOS400Shared + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuRemoveOS400Shared + "." + "OptionsPanel.detailCombo", false);
                        string = ".AfterRemoveVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.toDouble(this.getCurrentVirProc()) - this.toDouble(this.getMinVirProc()));
                            this.debug("getMaxVirProc() - getMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".IntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".MinIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".CurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".AfterRemoveIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    if (this.mAction.equals("move")) {
                        this.mUsrTaskMgr.setCaptionText("ProcessorMainPanel", string4 + " - " + string6 + " (" + string7 + ")");
                        this.debug(this.mCpuMoveOS400Shared);
                        this.mUsrTaskMgr.setShown(this.mCpuMoveOS400Shared, true);
                        this.mCurrentMoveToPanel = this.mCurrentPanel = this.mCpuMoveOS400Shared + "." + this.mCpuMoveOS400Shared + "General";
                        this.enablePanel(this.mCpuMoveOS400Shared);
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveOS400Shared + "." + "OptionsPanel.Number6", 28, "0");
                        this.mUsrTaskMgr.setAttribute(this.mCpuMoveOS400Shared + "." + "OptionsPanel.Number6", 29, "1092");
                        this.mUsrTaskMgr.setShown(this.mCpuMoveOS400Shared + "." + "OptionsPanel.detailCombo", false);
                        string = ".SourceAfterMoveVirProc";
                        if (!this.mfgDefConfig) {
                            d = this.setFormat(this.getSourceCurrentVirProc() - this.toDouble(this.getSourceMinVirProc()));
                            this.debug("getSourceMaxVirProc() - getSourceMinVirProc() = " + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 29, "" + d);
                            this.mUsrTaskMgr.setAttribute(this.mCurrentPanel + string, 28, "0");
                        }
                        if (!this.allowToShowCPW) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceMinIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceCurrentIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceAfterMoveIntPerf", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceOptimalIntRange", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".sourceIntRangeButton", false);
                        }
                    }
                    this.debug("OS400 Shared : reaching uncapped check box = " + this.mCurrentPanel);
                    if (this.sharingMode == 1) {
                        this.debug("reaching uncapped check box to TRUE");
                        if (!this.mAction.equals("move")) {
                            this.debug("setting values to uncapped and weight");
                            this.setUncapped(true);
                            this.setUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".UncappedCheckbox");
                        } else {
                            this.setSourceUncapped(true);
                            this.setSourceUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                        }
                    } else {
                        this.debug("reaching uncapped check box to FALSE");
                        if (!this.mAction.equals("move")) {
                            this.debug("setting values to uncapped and weight");
                            this.setUncapped(false);
                            this.setUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".UncappedCheckbox");
                        } else {
                            this.setSourceUncapped(false);
                            this.setSourceUncappedWeight(this.curUncappedWeight);
                            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".SourceUncappedCheckbox");
                        }
                    }
                    this.debug("reaching phypConfigProcUnits check=" + this.phypConfigProcUnits);
                    if (this.phypConfigProcUnits < 100) {
                        if (!this.mAction.equals("move")) {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".UncappedCheckbox", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".UncappedWeight", false);
                        } else {
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceUncappedCheckbox", false);
                            this.mUsrTaskMgr.setShown(this.mCurrentPanel + ".SourceUncappedWeight", false);
                        }
                    }
                }
            }
        }
        if (this.mAction.equals("move")) {
            this.debug("hiding move elements");
            this.hideMoveToElements();
            this.mUsrTaskMgr.refreshElement(this.mCurrentPanel + ".destLpar");
            this.debug("refresh destLpar");
        }
        if (this.OS400_PARTITION.equals(this.partType)) {
            try {
                if (this.allowToShowCPW) {
                    this.setPHYPIntRangeValues("sourceIntRangeButton", "bringup");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                HSCLogUtils.clientLog(exception, HSCLogUtils._DLPARClassLogInfo);
                this.debug("err in setDyna : " + exception.toString());
                this.showInfo(exception.toString(), null, null);
            }
        }
    }

    private void debug(String string) {
        if (IDebug.enabled) {
            System.err.println("| PROC." + string);
        }
    }

    private boolean checkVirProcForProcUnits(double d, double d2) {
        return !(d2 > d);
    }

    private int getVirProcProcUnits(double d, double d2) {
        this.debug("getVirProcProcUnits().virProc = " + d + " , procUnitForVirProc = " + d2);
        if (d2 > d) {
            return (int)Math.ceil(d2);
        }
        double d3 = this.setFormat(d2 - d);
        this.debug("diff = " + d3);
        double d4 = 0.0;
        d4 = d3 > 1.0 ? this.setFormat(Math.IEEEremainder(d3, 1.0)) : d3;
        this.debug("remainder = " + d4);
        int n = (int)(d3 + (2.0 - d4));
        this.debug("new vir proc value is = " + n);
        return n;
    }

    private boolean virProcLTMaxVirPorc(double d, double d2) {
        this.debug("virProcLTMaxVirPorc().virProc = " + d + " , maxVirProc = " + d2);
        if (d > d2) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_VIR_PROC_LT_MAX_VIR_PROC", "Current Virtual Processor should be less than Maximum Virtual Processor");
            this.showInfo(this.msg, null, null);
            return false;
        }
        return true;
    }

    private boolean virProcGTMinVirPorc(double d, double d2) {
        this.debug("virProcGTMinVirPorc().virProc = " + d + " , minVirProc = " + d2);
        if (d < d2) {
            this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "CUR_VIR_PROC_GT_MIN_VIR_PROC", "Current Virtual Processor should be greater than Minimum Virtual Processor");
            this.showInfo(this.msg, null, null);
            return false;
        }
        return true;
    }

    public boolean checkMaxVirProc() {
        this.debug("checkMaxVirProc()");
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.mAction.equals("add")) {
            d = (int)this.getAfterAddVirProc();
            this.debug("getAfterAddVirProc() : " + d);
            if (!this.virProcLTMaxVirPorc(d += this.setFormat(this.toDouble(this.getCurrentVirProc())), this.setFormat(this.toDouble(this.getMaxVirProc())))) {
                this.setAfterAddVirProc(0.0);
                return false;
            }
            if (!this.virProcGTMinVirPorc(d, this.setFormat(this.toDouble(this.getMinVirProc())))) {
                this.setAfterAddVirProc(0.0);
                return false;
            }
            d3 = this.setFormat(this.getAmtToAddProcUnits());
            d2 = d3 == 0.0 || d3 < 0.0 ? this.setFormat(this.toDouble(this.getCurrentProcUnits())) : this.setFormat(this.toDouble(this.getAfterAddProcUnits()));
            if (!this.checkVirProcForProcUnits(d, d2)) {
                int n = this.getVirProcProcUnits(d, d2);
                this.debug("newVirProc in add = " + n);
                Object[] objectArray = new String[]{"" + d2, "" + n};
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_CPU_VIR_PROC_PROC_UNIT", "The virtual processor for processing unit {0} should be more than or equal to {1}.", objectArray);
                this.debug("msg in vir proc map to proc units");
                this.showInfo(this.msg, null, null);
                return false;
            }
        } else if (this.mAction.equals("remove")) {
            d = (int)this.getAfterRemoveVirProc();
            this.debug("getAfterRemoveVirProc() : " + d);
            d = this.setFormat(this.setFormat(this.toDouble(this.getCurrentVirProc())) - d);
            if (!this.virProcLTMaxVirPorc(d, this.setFormat(this.toDouble(this.getMaxVirProc())))) {
                this.setAfterRemoveVirProc(0.0);
                return false;
            }
            if (!this.virProcGTMinVirPorc(d, this.setFormat(this.toDouble(this.getMinVirProc())))) {
                this.setAfterRemoveVirProc(0.0);
                return false;
            }
            d3 = this.setFormat(this.getAmtToRemoveProcUnits());
            d2 = d3 == 0.0 || d3 < 0.0 ? this.setFormat(this.toDouble(this.getCurrentProcUnits())) : this.setFormat(this.toDouble(this.getAfterRemoveProcUnits()));
            if (!this.checkVirProcForProcUnits(d, d2)) {
                int n = this.getVirProcProcUnits(d, d2);
                this.debug("newVirProc in Remove = " + n);
                Object[] objectArray = new String[]{"" + d2, "" + n};
                this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_CPU_VIR_PROC_PROC_UNIT", "The virtual processor for processing unit {0} should be more than or equal to {1}.", objectArray);
                this.debug("msg in vir proc map to proc units = " + this.msg);
                this.showInfo(this.msg, null, null);
                return false;
            }
        } else {
            String string = this.getMoveTo();
            String string2 = null;
            string2 = string != null && string.trim().length() > 0 && string.lastIndexOf("(") > 0 ? string.substring(0, string.lastIndexOf("(")) : string;
            this.debug("destLparName : " + string2);
            if (string2 == null || string2.trim().length() == 0) {
                this.showInfo(this.ERR_NO_CPU_MOVE_DEST, null, null);
                return false;
            }
            d = (int)this.getSourceAfterMoveVirProc();
            this.debug("getSourceAfterMoveVirProc() : " + d);
            if (d > 0.0) {
                d4 = this.getSourceCurrentVirProc();
                this.debug("getSourceCurrentVirProc() : " + d4);
                d = d4 - d;
                if (!this.virProcLTMaxVirPorc(d, this.setFormat(this.toDouble(this.getSourceMaxVirProc())))) {
                    this.setSourceAfterMoveVirProc(0.0);
                    return false;
                }
                if (!this.virProcGTMinVirPorc(d, this.setFormat(this.toDouble(this.getSourceMinVirProc())))) {
                    this.setSourceAfterMoveVirProc(0.0);
                    return false;
                }
                d3 = this.setFormat(this.getSourceAmtToMoveProcUnits());
                d2 = d3 == 0.0 || d3 < 0.0 ? this.setFormat(this.toDouble(this.getSourceCurrentProcUnits())) : this.setFormat(this.getSourceAfterMoveProcUnits());
                if (!this.checkVirProcForProcUnits(d, d2)) {
                    int n = this.getVirProcProcUnits(d, d2);
                    this.debug("new vir proc in move = " + n);
                    Object[] objectArray = new String[]{"" + d2, "" + n};
                    this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_CPU_VIR_PROC_PROC_UNIT", "The virtual processor for processing unit {0} should be more than or equal to {1}.", objectArray);
                    this.showInfo(this.msg, null, null);
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    protected boolean saveChanges() {
        String string = null;
        String string2 = "addCpu";
        int n = -1;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 8;
        int n5 = -1;
        int n6 = -1;
        double d4 = -1.0;
        double d5 = -1.0;
        Object[] objectArray = null;
        if (this.mAction.equals("add")) {
            if (!this.closePanel) {
                this.closePanel = true;
                return false;
            }
            if (this.OS400_PARTITION.equals(this.partType)) {
                d2 = this.getAfterAddIntPerf();
                this.debug("addCpu().OS400.Changed  Int perf value = " + d2);
                d2 = d2 * 100.0 == (double)this.curIntPerf ? -1.0 : (d2 *= 100.0);
            }
            if (255 != this.procMode) {
                d = this.getAmtToAddProcUnits();
                this.debug("addCpu().SharedProc.Changed Proc Units = " + d * 100.0);
                if (d * 100.0 > 0.0) {
                    d *= 100.0;
                    if (!this.mfgDefConfig && this.setFormat(d / 100.0) > this.setFormat(this.mAddProcUnitsNum / 100.0)) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_PROC_UNITS_ADD", "You have attempted to add {0} processing units, which is larger than the maximum allowed value {1}.", new String[]{"" + this.setFormat(d / 100.0), "" + this.setFormat(this.mAddProcUnitsNum / 100.0)});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                } else {
                    d = -1.0;
                }
                if ((n3 = (int)this.getAfterAddVirProc()) == 0) {
                    n3 = -1;
                }
                this.debug("addCpu().VirProc.Changed Virtual Proc = " + n3 * 100);
                if (this.isUncapped()) {
                    this.debug("in getUncapped()=true");
                    d4 = (int)this.getUncappedWeight();
                    this.debug("uncappedWeight=" + d4);
                    n5 = 1;
                } else {
                    n5 = this.sharingMode == 1 ? 0 : -1;
                }
            } else {
                n = (int)this.getAmtToAddProcs();
                if (n > 0) {
                    this.debug("mfgDefConfig=" + this.mfgDefConfig);
                    if (!this.mfgDefConfig && n > this.mAddNum) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_ADD", "HMCERRV4DLPAR025: You have attempted to add {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n, "" + this.mAddNum});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                } else {
                    n = -1;
                }
            }
            string2 = "addCpu";
        } else if (this.mAction.equals("remove")) {
            if (!this.closePanel) {
                this.closePanel = true;
                return false;
            }
            if (this.OS400_PARTITION.equals(this.partType)) {
                d2 = this.getAfterRemoveIntPerf();
                this.debug("removeCpu().Changed  Int perf value = " + d2 * 100.0);
                d2 = d2 * 100.0 != (double)this.curIntPerf ? (d2 *= 100.0) : -1.0;
            }
            if (255 != this.procMode) {
                d = this.getAmtToRemoveProcUnits();
                this.debug("removeCpu().Changed Proc Units = " + d * 100.0);
                if (d * 100.0 > 0.0) {
                    d *= 100.0;
                    if (!this.mfgDefConfig && this.setFormat(d / 100.0) > this.setFormat(this.mRemoveProcUnitsNum / 100.0)) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_PROC_UNITS_REMOVE", "You have attempted to remove {0} processing units, which is larger than the minimum allowed value {1}.", new String[]{"" + this.setFormat(d / 100.0), "" + this.setFormat(this.mRemoveProcUnitsNum / 100.0)});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                } else {
                    d = -1.0;
                }
                if ((n3 = (int)this.getAfterRemoveVirProc()) == 0) {
                    n3 = -1;
                }
                this.debug("removeCpu().VirProc.Changed Virtual Proc = " + n3 * 100);
                if (this.isUncapped()) {
                    d4 = (int)this.getUncappedWeight();
                    n5 = 1;
                } else {
                    n5 = this.sharingMode == 1 ? 0 : -1;
                }
            } else {
                n = (int)this.getAmtToRemoveProcs();
                if (n > 0) {
                    if (!this.mfgDefConfig && n > this.mRemoveNum) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to remove {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n, "" + this.mRemoveNum});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                } else {
                    n = -1;
                }
            }
            string2 = "removeCpu";
        } else if (this.mAction.equals("move")) {
            string2 = "moveCpu";
            if (this.OS400_PARTITION.equals(this.partType)) {
                d2 = this.getSourceAfterMoveIntPerf();
                this.debug("moveCpu().Changed  Int perf value = " + (d2 -= this.getSourceCurrentIntPerf()) * 100.0);
                d2 = d2 * 100.0 != (double)this.curIntPerf ? (d2 *= 100.0) : -1.0;
            }
            if (this.OS400_PARTITION.equals(this.destPartType)) {
                d3 = this.getDestAfterMoveIntPerf();
                if (d3 > 0.0) {
                    this.debug("moveCpu().Changed dest Int perf value = " + d3 * 100.0);
                    d3 = d3 * 100.0 > 0.0 ? (d3 *= 100.0) : -1.0;
                } else {
                    d3 = -1.0;
                }
            }
            if (255 != this.procMode) {
                d = this.getSourceAmtToMoveProcUnits();
                this.debug("moveCpu().Changed Proc Units = " + d * 100.0);
                if (d * 100.0 > 0.0) {
                    if (this.setFormat((d *= 100.0) / 100.0) > this.setFormat(this.mMoveProcUnitsNum / 100.0)) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_PROC_UNITS_MOVE", "You have attempted to remove {0} processing units, which is larger than the minimum allowed value {1}.", new String[]{"" + this.setFormat(d / 100.0), "" + this.setFormat(this.mMoveProcUnitsNum / 100.0)});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                } else {
                    d = -1.0;
                }
                if ((n3 = (int)this.getSourceAfterMoveVirProc()) == 0) {
                    n3 = -1;
                }
                this.debug("moveCpu().VirProc.Changed Virtual Proc = " + n3 * 100);
                if (this.isSourceUncapped()) {
                    d4 = (int)this.getSourceUncappedWeight();
                    n5 = 1;
                } else {
                    n5 = this.sharingMode == 1 ? 0 : -1;
                }
            } else {
                n = (int)this.getSourceAmtToMoveProcs();
                if (n > 0) {
                    if (n > this.mMoveNum) {
                        this.msg = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_MAX_CPU_REMOVE", "You have attempted to move {0} processors, which is larger than the maximum allowed value {1}.", new String[]{"" + n, "" + this.mRemoveNum});
                        this.showInfo(this.msg, null, null);
                        return false;
                    }
                    if (n <= 0) {
                        this.showInfo(this.ERR_NO_CPU_SEL, null, null);
                        return false;
                    }
                } else {
                    n = -1;
                }
            }
            n4 += 4;
            String string3 = this.getMoveTo();
            string = string3 != null && string3.trim().length() > 0 && string3.lastIndexOf("(") > 0 ? string3.substring(0, string3.lastIndexOf("(")) : string3;
            this.debug("destLparName : " + string);
            if (string == null || string.trim().length() == 0) {
                this.showInfo(this.ERR_NO_CPU_MOVE_DEST, null, null);
                return false;
            }
            if (255 != this.destProcMode) {
                if (this.isDestUncapped()) {
                    d5 = this.getDestUncappedWeight();
                    n6 = 1;
                } else {
                    n6 = this.destSharingMode == 1.0 ? 0 : -1;
                }
            }
        } else {
            return false;
        }
        this.debug("proc=" + n + ", procUnits=" + d + ", intPerf=" + d2 + ", destIntPerf=" + d3 + ", destVirProc=" + n2 + ", virProc=" + n3 + ", shareMode=" + n5 + ", uncappedWeight=" + d4 + ", destUncappedWeight=" + d5 + ",destShareMode=" + n6);
        if (n == -1 && d == -1.0 && d2 == -1.0 && d3 == -1.0 && n2 == -1 && n3 == -1 && n5 == -1 && d4 == -1.0 && d5 == -1.0 && n6 == -1) {
            return true;
        }
        short s = (short)this.getDetail();
        int n7 = (int)this.getTimeout();
        objectArray = new Object[n4];
        int n8 = 0;
        objectArray[n8++] = 255 == this.procMode ? new Integer(n) : new Integer(n3);
        if (string != null) {
            objectArray[n8++] = string;
        }
        objectArray[n8++] = new Long((long)d);
        objectArray[n8++] = new Integer((int)d2);
        objectArray[n8++] = new Integer((int)d4);
        objectArray[n8++] = new Integer(n7);
        objectArray[n8++] = new Short(s);
        objectArray[n8++] = this.mNoRMCConnection ? new Boolean(true) : new Boolean(false);
        objectArray[n8++] = new Integer(n5);
        if (this.mAction.equals("move")) {
            objectArray[n8++] = new Integer((int)d3);
            objectArray[n8++] = (double)this.destCurUncappedWeight != d5 ? new Integer((int)d5) : new Integer(-1);
            objectArray[n8++] = new Integer(n6);
        }
        this.saveDataToServer(string2, objectArray, s <= 0, "all");
        return true;
    }
}

